% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sconeReport.R
\name{sconeReport}
\alias{sconeReport}
\title{SCONE Report Browser: Browse Evaluation of Normalization Performance}
\usage{
sconeReport(
  x,
  methods,
  qc,
  bio = NULL,
  batch = NULL,
  poscon = character(),
  negcon = character(),
  eval_proj = NULL,
  eval_proj_args = NULL
)
}
\arguments{
\item{x}{a \code{SconeExperiment} object}

\item{methods}{character specifying the normalizations to report.}

\item{qc}{matrix. QC metrics to be used for QC evaluation report. Required.}

\item{bio}{factor. A biological condition (variation to be preserved).
Default NULL.}

\item{batch}{factor. A known batch variable (variation to be removed).
Default NULL.}

\item{poscon}{character. Genes to be used as positive controls for
evaluation. These genes should be expected to change according to the
biological phenomenon of interest. Default empty character.}

\item{negcon}{character. Genes to be used as negative controls for
evaluation. These genes should be expected not to change according to the
biological phenomenon of interest. Default empty character.}

\item{eval_proj}{function. Projection function for evaluation  (see
\code{\link{score_matrix}} for details). If NULL, PCA is used for
projection.}

\item{eval_proj_args}{list. List of args passed to projection function as
eval_proj_args.}
}
\value{
An object that represents the SCONE report app.
}
\description{
This function opens a shiny application session for visualizing performance
of a variety of normalization schemes.
}
\examples{
set.seed(101)
mat <- matrix(rpois(1000, lambda = 5), ncol=10)
colnames(mat) <- paste("X", 1:ncol(mat), sep="")
obj <- SconeExperiment(mat)
res <- scone(obj, scaling=list(none=identity, uq=UQ_FN, deseq=DESEQ_FN),
           evaluate=TRUE, k_ruv=0, k_qc=0, eval_kclust=2,
           bpparam = BiocParallel::SerialParam())
qc = as.matrix(cbind(colSums(mat),colSums(mat > 0)))
rownames(qc) = colnames(mat)
colnames(qc) = c("NCOUNTS","NGENES")
\dontrun{
sconeReport(res,rownames(get_params(res)), qc = qc)
}

}
