% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoreMethods.R
\docType{methods}
\name{scmapCluster}
\alias{scmapCluster}
\alias{scmapCluster}
\alias{scmapCluster.SingleCellExperiment}
\alias{scmapCluster,SingleCellExperiment-method}
\alias{scmapCluster}
\title{scmap main function}
\usage{
scmapCluster(projection = NULL, index_list = NULL, threshold = 0.7)

scmapCluster.SingleCellExperiment(projection, index_list, threshold)

\S4method{scmapCluster}{SingleCellExperiment}(projection = NULL,
  index_list = NULL, threshold = 0.7)
}
\arguments{
\item{projection}{`SingleCellExperiment` object to project}

\item{index_list}{list of index objects each coming from the output of `indexCluster`}

\item{threshold}{threshold on similarity (or probability for SVM and RF)}
}
\value{
The projection object of \code{\link[SingleCellExperiment]{SingleCellExperiment}} class with labels calculated by `scmap` and stored in 
the \code{scmap_labels} column of the \code{rowData(object)} slot.
}
\description{
Projection of one dataset to another
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(normcounts = as.matrix(yan)), colData = ann)
# this is needed to calculate dropout rate for feature selection
# important: normcounts have the same zeros as raw counts (fpkm)
counts(sce) <- normcounts(sce)
logcounts(sce) <- log2(normcounts(sce) + 1)
# use gene names as feature symbols
rowData(sce)$feature_symbol <- rownames(sce)
# remove features with duplicated names
sce <- sce[!duplicated(rownames(sce)), ]
sce <- selectFeatures(sce)
sce <- indexCluster(sce)
sce <- scmapCluster(sce, list(metadata(sce)$scmap_cluster_index))

}
