% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spe2PB.R
\name{spe2PB}
\alias{spe2PB}
\title{Given a 'SpatialExperiment' data object, create pseudo-bulk
samples using the colData information and return a DGEList object}
\usage{
spe2PB(
  spe,
  by.group = TRUE,
  group.id = "cell_type",
  keep.groups = NULL,
  roi = NULL,
  roi.only = TRUE,
  contour = NULL
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{by.group}{Logical. Whether to perform pseudo-bulking by group.
TRUE by default.}

\item{group.id}{Character. The column name of the colData(spe) that
contains the group information. Default to 'cell_type'.}

\item{keep.groups}{Vector. Values from group.id to include in pseudo-
bulking. Default is NULL, where all cells are included in pseudo-bulking.}

\item{roi}{Character. The name of the group or cell type on which
the roi is computed.
If NULL, then no pseudo-bulking will be performed based on roi.
Default to NULL.}

\item{roi.only}{Logical. Whether to filter out pseudo-bulk samples formed
by cells not in any ROIs. TRUE by default.}

\item{contour}{Character. The name of the group or cell type on which
the contour level is computed.
If NULL, then no pseudo-bulking will be performed based on contour level.
Default to NULL.}
}
\value{
An edgeR::DGEList object where each library (column) is a
pseudo-bulk sample.
}
\description{
Given a 'SpatialExperiment' data object, create pseudo-bulk
samples using the colData information and return a DGEList object
}
\examples{

data("xenium_bc_spe")

spe <- gridDensity(spe)

coi <- "Breast cancer"

spe <- findROI(spe, coi = coi)

spe <- allocateCells(spe, to.contour=FALSE)

y <- spe2PB(spe, roi = coi)

}
