% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid2sf.R
\name{grid2sf}
\alias{grid2sf}
\title{Convert x,y nodes to sf polygons}
\usage{
grid2sf(
  spe,
  x = spe@metadata$grid_density$node_x,
  y = spe@metadata$grid_density$node_y,
  reverseY = FALSE
)
}
\arguments{
\item{spe}{A SpatialExperiment object with grid density calculated}

\item{x}{vector of x nodes of the polygons}

\item{y}{vector of y nodes of the polygons}

\item{reverseY}{Reverse y coordinates. Can be numeric to specify the value to
subtract y coordinates from (reverseY - y coords).}
}
\value{
List of sf polygons
}
\description{
Convert x,y nodes to sf polygons
}
\details{
Default is to generate sf polygons for all grid.
For plotting with geom_sf, use sf::st_as_sfc(grid2sf2(spe)) to convert list
into Geometry Set.
}
