% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hexbin_feature.R
\name{plot_hexbin_feature}
\alias{plot_hexbin_feature}
\title{Plot of feature expression of single cells in bivariate hexagon cells.}
\usage{
plot_hexbin_feature(
  sce,
  mod = "RNA",
  type,
  feature,
  action,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  lower_cutoff = 0,
  upper_cutoff = 1
)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{mod}{A string referring to the name of the modality used for plotting.
For RNA modality use "RNA". For other modalities use name of alternative
object for the \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{type}{A string referring to the type of assay in the
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{feature}{A string referring to the name of one feature.}

\item{action}{A strings pecifying how meta data of observations in
binned  hexagon cells are to be summarized. Possible actions are
\code{prop_0}, \code{mode}, \code{mean} and \code{median} (see details).}

\item{title}{A string containing the title of the plot.}

\item{xlab}{A string containing the title of the x axis.}

\item{ylab}{A string containing the title of the y axis.}

\item{lower_cutoff}{For \code{mode}, \code{mean} and \code{median} actions,
remove expression values below this quantile. Expressed as decimal.
Default: 0}

\item{upper_cutoff}{For \code{mode}, \code{mean} and \code{median} actions,
remove expression values above this quantile. Expressed as decimal.
Default: 1}
}
\value{
A \code{\link{ggplot2}{ggplot}} object.
}
\description{
Plot of feature expression of single cells in bivariate hexagon cells.
}
\details{
This function plots the expression of any feature in the hexagon
   cell representation calculated with \code{\link{make_hexbin}}. The chosen
   gene expression is summarized by one of four actions \code{prop_0},
   \code{mode}, \code{mean} and \code{median}:

   \describe{
     \item{\code{prop_0}}{Returns the proportion of observations in the bin
      greater than 0. The associated meta data column needs to be numeric.}
     \item{\code{mode}}{Returns the mode of the observations in the bin. The
      associated meta data column needs to be numeric.}
     \item{\code{mean}}{Returns the mean of the observations in the bin. The
      associated meta data column needs to be numeric.}
      \item{\code{median}}{Returns the median of the observations in the bin.
      The associated meta data column needs to be numeric.}
   }
}
\examples{
# For SingleCellExperiment object
library(TENxPBMCData)
library(scater)
tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
rm_ind <- calculateAverage(tenx_pbmc3k) < 0.1
tenx_pbmc3k <- tenx_pbmc3k[!rm_ind, ]
colData(tenx_pbmc3k) <- cbind(
    colData(tenx_pbmc3k),
    perCellQCMetrics(tenx_pbmc3k)
)
tenx_pbmc3k <- logNormCounts(tenx_pbmc3k)
tenx_pbmc3k <- runPCA(tenx_pbmc3k)
tenx_pbmc3k <- make_hexbin(tenx_pbmc3k, 20, dimension_reduction = "PCA")
plot_hexbin_feature(tenx_pbmc3k,
    type = "logcounts",
    feature = "ENSG00000135250", action = "median"
)
plot_hexbin_feature(tenx_pbmc3k,
    type = "logcounts",
    feature = "ENSG00000135250", action = "mode"
)
}
