% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_calls.R
\name{get_dblCalls_dist}
\alias{get_dblCalls_dist}
\title{Derive doublet calls from doublset scores}
\usage{
get_dblCalls_dist(scrs_real, scrs_sim, type = "balanced")
}
\arguments{
\item{scrs_real}{numeric vector, the scores for the real/original data}

\item{scrs_sim}{numeric vector, the scores for the artificial doublets}

\item{type}{character or numeric, describes how the score threshold for calling doublets is determined. Either \code{"balanced"} or a number between zero and one that indicates the fraction of artificial doublets missed when making calls. Default: \code{"balanced"}.}
}
\value{
numeric, vector containing the (estimated) number of doublets, the score threshold and the fraction of artificial doublets missed (false negative rate, of sorts)
}
\description{
Given score vectors for real data and artificial doubles, derive doublet calls based on determining doublet score cutoffs.
}
