% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.test.gene.expression.difference}
\alias{scde.test.gene.expression.difference}
\title{Test differential expression and plot posteriors for a particular gene}
\usage{
scde.test.gene.expression.difference(gene, models, counts, prior,
  groups = NULL, batch = NULL, batch.models = models,
  n.randomizations = 1000, show.plots = TRUE, return.details = FALSE,
  verbose = FALSE, ratio.range = NULL, show.individual.posteriors = TRUE,
  n.cores = 1)
}
\arguments{
\item{gene}{name of the gene to be tested}

\item{models}{models}

\item{counts}{read count matrix (must contain the row corresponding to the specified gene)}

\item{prior}{expression magnitude prior}

\item{groups}{a two-level factor specifying between which cells (rows of the models matrix) the comparison should be made}

\item{batch}{optional multi-level factor assigning the cells (rows of the model matrix) to different batches that should be controlled for (e.g. two or more biological replicates). The expression difference estimate will then take into account the likely difference between the two groups that is explained solely by their difference in batch composition. Not all batch configuration may be corrected this way.}

\item{batch.models}{optional set of models for batch comparison (typically the same as models, but can be more extensive, or recalculated within each batch)}

\item{n.randomizations}{number of bootstrap/sampling iterations that should be performed}

\item{show.plots}{whether the plots should be shown}

\item{return.details}{whether the posterior should be returned}

\item{verbose}{set to T for some status output}

\item{ratio.range}{optionally specifies the range of the log2 expression ratio plot}

\item{show.individual.posteriors}{whether the individual cell expression posteriors should be plotted}

\item{n.cores}{number of cores to use (default = 1)}
}
\value{
by default returns MLE of log2 expression difference, 95% CI (upper, lower bound), and a Z-score testing for expression difference. If return.details = TRUE, a list is returned containing the above structure, as well as the expression fold difference posterior itself.
}
\description{
The function performs differential expression test and optionally plots posteriors for a specified gene.
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
data(o.ifm)  # Load precomputed model. Use ?scde.error.models to see how o.ifm was generated
o.prior <- scde.expression.prior(models = o.ifm, counts = cd, length.out = 400, show.plot = FALSE)
scde.test.gene.expression.difference("Tdh", models = o.ifm, counts = cd, prior = o.prior)

}

