% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.expression.difference}
\alias{scde.expression.difference}
\title{Test for expression differences between two sets of cells}
\usage{
scde.expression.difference(models, counts, prior, groups = NULL,
  batch = NULL, n.randomizations = 150, n.cores = 10,
  batch.models = models, return.posteriors = FALSE, verbose = 0)
}
\arguments{
\item{models}{models determined by \code{\link{scde.error.models}}}

\item{counts}{read count matrix}

\item{prior}{gene expression prior as determined by \code{\link{scde.expression.prior}}}

\item{groups}{a factor determining the two groups of cells being compared. The factor entries should correspond to the rows of the model matrix. The factor should have two levels. NAs are allowed (cells will be omitted from comparison).}

\item{batch}{a factor (corresponding to rows of the model matrix) specifying batch assignment of each cell, to perform batch correction}

\item{n.randomizations}{number of bootstrap randomizations to be performed}

\item{n.cores}{number of cores to utilize}

\item{batch.models}{(optional) separate models for the batch data (if generated using batch-specific group argument). Normally the same models are used.}

\item{return.posteriors}{whether joint posterior matrices should be returned}

\item{verbose}{integer verbose level (1 for verbose)}
}
\value{
\subsection{default}{
a data frame with the following fields:
\itemize{
\item{lb, mle, ub} {lower bound, maximum likelihood estimate, and upper bound of the 95% confidence interval for the expression fold change on log2 scale.}
\item{ce} { conservative estimate of expression-fold change (equals to the min(abs(c(lb, ub))), or 0 if the CI crosses the 0}
\item{Z} { uncorrected Z-score of expression difference}
\item{cZ} {expression difference Z-score corrected for multiple hypothesis testing using Holm procedure}
}
 If batch correction has been performed (\code{batch} has been supplied), analogous data frames are returned in slots \code{$batch.adjusted} for batch-corrected results, and \code{$batch.effect} for the differences explained by batch effects alone.
}}
\subsection{return.posteriors = TRUE}{
A list is returned, with the default results data frame given in the \code{$results} slot.
\code{difference.posterior} returns a matrix of estimated expression difference posteriors (rows - genes, columns correspond to different magnitudes of fold-change - log2 values are given in the column names)
\code{joint.posteriors} a list of two joint posterior matrices (rows - genes, columns correspond to the expression levels, given by prior$x grid)
}
}
\description{
Use the individual cell error models to test for differential expression between two groups of cells.
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
sg <- factor(gsub("(MEF|ESC).*", "\\\\1", colnames(cd)), levels = c("ESC", "MEF"))
names(sg) <- colnames(cd)
\donttest{
o.ifm <- scde.error.models(counts = cd, groups = sg, n.cores = 10, threshold.segmentation = TRUE)
o.prior <- scde.expression.prior(models = o.ifm, counts = cd, length.out = 400, show.plot = FALSE)
# make sure groups corresponds to the models (o.ifm)
groups <- factor(gsub("(MEF|ESC).*", "\\\\1", rownames(o.ifm)), levels = c("ESC", "MEF"))
names(groups) <- row.names(o.ifm)
ediff <- scde.expression.difference(o.ifm, cd, o.prior, groups = groups, n.randomizations = 100, n.cores = n.cores, verbose = 1)
}

}

