% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make.pagoda.app}
\alias{make.pagoda.app}
\title{Make the PAGODA app}
\usage{
make.pagoda.app(tamr, tam, varinfo, env, pwpca, clpca = NULL,
  col.cols = NULL, cell.clustering = NULL, row.clustering = NULL,
  title = "pathway clustering", zlim = c(-1, 1) * quantile(tamr$xv, p =
  0.95))
}
\arguments{
\item{tamr}{Combined pathways that show similar expression patterns. Output of \code{\link{pagoda.reduce.redundancy}}}

\item{tam}{Combined pathways that are driven by the same gene sets. Output of \code{\link{pagoda.reduce.loading.redundancy}}}

\item{varinfo}{Variance information. Output of \code{\link{pagoda.varnorm}}}

\item{env}{Gene sets as an environment variable.}

\item{pwpca}{Weighted PC magnitudes for each gene set provided in the \code{env}. Output of \code{\link{pagoda.pathway.wPCA}}}

\item{clpca}{Weighted PC magnitudes for de novo gene sets identified by clustering on expression. Output of \code{\link{pagoda.gene.clusters}}}

\item{col.cols}{Matrix of column colors. Useful for visualizing cell annotations such as batch labels. Default NULL.}

\item{cell.clustering}{Dendrogram of cell clustering. Output of \code{\link{pagoda.cluster.cells} } . Default   NULL.}

\item{row.clustering}{Dendrogram of combined pathways clustering. Default NULL.}

\item{title}{Title text to be used in the browser label for the app. Default, set as 'pathway clustering'}

\item{zlim}{Range of the normalized gene expression levels, inputted as a list: c(lower_bound, upper_bound). Values outside this range will be Winsorized. Useful for increasing the contrast of the heatmap visualizations. Default, set to the 5th and 95th percentiles.}
}
\value{
PAGODA app
}
\description{
Create an interactive user interface to explore output of PAGODA.
}

