% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\docType{data}
\name{sccomp_stan_models_cache_dir}
\alias{sccomp_stan_models_cache_dir}
\title{Default cache directory for Stan models}
\format{
An object of class \code{character} of length 1.
}
\usage{
sccomp_stan_models_cache_dir
}
\value{
A character string containing the path to the default cache directory.
}
\description{
A global variable that defines the default cache directory for Stan models used by the sccomp package.
This directory is used to store compiled Stan models to avoid recompilation on subsequent runs.
}
\details{
The cache directory is set to \code{~/.sccomp_models} by default. This location is used by
various sccomp functions to store and retrieve compiled Stan models, improving performance
by avoiding unnecessary recompilation of models that have already been compiled.

Users can override this default by specifying a different cache directory in function calls
that accept a \code{cache_stan_model} parameter.
}
\examples{
# View the default cache directory
sccomp_stan_models_cache_dir

# Use a custom cache directory in a function call
# sccomp_estimate(data, cache_stan_model = "/path/to/custom/cache")

}
\seealso{
\code{\link{sccomp_estimate}}, \code{\link{sccomp_replicate}}, \code{\link{clear_stan_model_cache}}
}
\keyword{datasets}
