% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClusterVAF.R
\name{plotClusterVAF}
\alias{plotClusterVAF}
\title{plot Cluster VAF
This function generates a plot to visualize variant allele frequency (VAF) in
 clusters based on selected variants of interest.}
\usage{
plotClusterVAF(sce, variants.of.interest, gg.clust)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing the relevant data.}

\item{variants.of.interest}{A vector specifying the variants of interest.}

\item{gg.clust}{An object containing clustering information.}
}
\value{
A ggplot object that visually represents the VAF in the clusters.
}
\description{
plot Cluster VAF
This function generates a plot to visualize variant allele frequency (VAF) in
 clusters based on selected variants of interest.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with variants in altExp() and
# clusterplot is the output of clusterVariantSleection().
sce_filtered <- readRDS(system.file("extdata", "sce_filtered_demo.rds",
    package = "scafari"
))
clusterplot <- readRDS(system.file("extdata", "clusterplot.rds",
    package = "scafari"
))
plotClusterVAF(
    sce = sce_filtered,
    variants.of.interest = c(
        "FLT3:chr13:28610183:A/G",
        "KIT:chr4:55599436:T/C",
        "TP53:chr17:7577427:G/A",
        "TET2:chr4:106158216:G/A"
    ),
    gg.clust = clusterplot$clusterplot
)

}
