% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterVariantSelection.R
\name{clusterVariantSelection}
\alias{clusterVariantSelection}
\title{Function: clusterVariantSelection
This function takes selected variants and performs clustering on them.}
\usage{
clusterVariantSelection(
  sce,
  variants.of.interest,
  n.clust,
  method = "k-means",
  eps.value = 0.2,
  resolution = NULL,
  min.pts = NULL
)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing the single-cell data on
which clustering will be performed.}

\item{variants.of.interest}{A vector or list specifying the variants of
interest to be selected for clustering.}

\item{n.clust}{An integer specifying the number of clusters.}

\item{method}{Clustering method. Either k-means, dbscan or leiden.}

\item{eps.value}{Size (radius) of the epsilon neighborhood. Can be omitted
if x is a frNN object.}

\item{resolution}{The resolution parameter to use. Higher resolutions lead
to more smaller communities, while lower resolutions lead to fewer larger
communities.}

\item{min.pts}{Number of minimum points required in the eps neighborhood
for core points (including the point itself). By default cell number/100.}
}
\value{
A list with clustering results and a ggplot-object.
}
\description{
Function: clusterVariantSelection
This function takes selected variants and performs clustering on them.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with variants in altExp()
sce_filtered <- readRDS(system.file("extdata", "sce_filtered_demo.rds",
    package = "scafari"
))
clusterplot <- clusterVariantSelection(
    sce = sce_filtered,
    variants.of.interest = c(
        "FLT3:chr13:28610183:A/G",
        "KIT:chr4:55599436:T/C",
        "TP53:chr17:7577427:G/A",
        "TET2:chr4:106158216:G/A"
    ),
    n.clust = 4
)

}
\references{
https://cran.r-project.org/web/packages/dbscan/readme/
README.html#ref-hahsler2019dbscan
}
