% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{createFromSCE}
\alias{createFromSCE}
\title{Creates a `TreeViz`` object from `SingleCellExperiment`. Generates
clusters based on Walktrap algorithm if no default is provided}
\usage{
createFromSCE(
  object,
  check_coldata = FALSE,
  col_regex = NULL,
  columns = NULL,
  reduced_dim = c("TSNE")
)
}
\arguments{
\item{object}{`SingleCellExperiment` object to be visualized}

\item{check_coldata}{whether to colData of `SingeCellExperiment` object for cluster information or not}

\item{col_regex}{common regular expression shared across all columns with cluster information}

\item{columns}{vector containing columns with cluster information}

\item{reduced_dim}{Vector of Dimensionality reduction information provided in `SingeCellExperiment` object to be added in `TreeViz` (if exists)}
}
\value{
`TreeViz` Object
}
\description{
Creates a `TreeViz`` object from `SingleCellExperiment`. Generates
clusters based on Walktrap algorithm if no default is provided
}
\examples{
library(SingleCellExperiment)
library(scater)
sce <- mockSCE()
sce <- logNormCounts(sce)
sce <- runTSNE(sce)
sce <- runUMAP(sce)
set.seed(1000)
for (i in  seq_len(5)) {
clust.kmeans <- kmeans(reducedDim(sce, "TSNE"), centers = i)
sce[[paste0("clust", i)]] <- factor(clust.kmeans$cluster)
}
treeviz <-createFromSCE(sce, check_coldata = TRUE, col_regex = "clust", reduced_dim = c("TSNE", "UMAP"))

}
