% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeViz-class.R
\name{TreeViz}
\alias{TreeViz}
\title{The TreeViz class.}
\usage{
TreeViz(assays = SimpleList(), rowData = NULL, colData = NULL, ...)
}
\arguments{
\item{assays}{simple list of counts}

\item{rowData}{rowData}

\item{colData}{colData}

\item{...}{other parameters for SummarizedExperiment}
}
\value{
a `TreeViz` object
}
\description{
SummarizedExperiment-like class for datasets that have hierarchies on either rowData or colData.
For microbiome data, rowData is a tree hierarchy
For single cell data, colData is a tree hierarchy
}
\examples{
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
mbiome <- TreeViz(SimpleList(counts=counts), rowData=tree)
}
