% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeIndex-methods.R
\name{[,TreeIndex,ANY,ANY,ANY-method}
\alias{[,TreeIndex,ANY,ANY,ANY-method}
\alias{getNodes}
\alias{getNodes,TreeIndex-method}
\alias{getNodeStates}
\alias{getNodeStates,TreeIndex-method}
\alias{splitAt}
\alias{splitAt,TreeIndex-method}
\alias{show,TreeIndex-method}
\title{Subset TreeIndex}
\usage{
\S4method{[}{TreeIndex,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

getNodes(x, ...)

\S4method{getNodes}{TreeIndex}(x, selectedLevel = NULL)

getNodeStates(x)

\S4method{getNodeStates}{TreeIndex}(x)

splitAt(x, ...)

\S4method{splitAt}{TreeIndex}(
  x,
  selectedLevel = 3,
  selectedNodes = NULL,
  start = 1,
  end = NULL,
  format = "list"
)

\S4method{show}{TreeIndex}(object)
}
\arguments{
\item{x}{TreeIndex object}

\item{i, j}{indices to subset or keep}

\item{...}{other parameters}

\item{drop}{drop the dimensions of the object. defaults to FALSE}

\item{selectedLevel}{tree level to select nodes from}

\item{selectedNodes}{used to set states on individual nodes to define a cut on the tree}

\item{start, end}{indices to filter nodes by}

\item{format}{return format can be one of "list" or "TreeIndex"}

\item{object}{TreeIndex object}
}
\value{
a `TreeIndex` subset object

a generic

levels at node cut

node state

node states

a generic

a `TreeIndex` object or type set in format

object description of the `TreeIndex` object
}
\description{
Subset TreeIndex

Generic method to get nodes at a tree level

Method to get nodes at a tree level

Generic method for possible node states

Method to get possible node states
a node state is 0 if removed, 1 if expanded to show children &
2 if counts are aggregated to the node

Generic method to split the tree

splitAt divides the TreeIndex into groups defined by the level,
node selections and filters(start, end)

Show the TreeIndex object
}
\examples{
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
getNodes(tree)
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
getNodes(tree)
\donttest{ 
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
splitAt(tree)
}
\donttest{ 
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
splitAt(tree)
}
}
