% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_models.R
\name{fit_models}
\alias{fit_models}
\title{fit_models}
\usage{
fit_models(counts, cexpr, lib.size, formula = NULL, model = NULL, BPPARAM)
}
\arguments{
\item{counts}{A non-negative integer matrix of scRNA-seq filtered read counts
containing genes belonging to the family of ZINB distributions selected from
\code{ks_test}.}

\item{cexpr}{A dataframe that contains the covariate values.
The rows of the dataframe are the corresponding samples/cells from the counts
matrix from \code{filter_counts}.
The cells of the dataframe are the covariates to be included in the GLM.}

\item{lib.size}{A numeric vector that contains the total number of counts
per cell from the counts matrix from \code{filter_counts}.}

\item{formula}{A regression formula to fit the covariates in the ZINB GLM.}

\item{model}{A specific model to fit (1:P, 2:NB, 3:ZIP, 4:ZINB, NULL:All)}

\item{BPPARAM}{configuration parameter related to the method of parallel execution.
For further information on how to set-up parallel execution refer to
\code{BiocParallel} vignette.}
}
\value{
A list of models fitted by 'glm'
}
\description{
This function is used to fit genes with GLM
}
\examples{

data(scData)

# apply the fit_models function to subset genes belonging to the
# family of ZINB distributions, selceted from ks_test function.

library(BiocParallel)
scData_models <- fit_models(counts=scData$counts, cexpr=scData$covariates,
lib.size=scData$lib_size, BPPARAM=bpparam())
}
