% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scRecoverTest.R
\docType{data}
\name{scRecoverTest}
\alias{scRecoverTest}
\alias{counts}
\alias{labels}
\alias{oneCell}
\title{scRecoverTest: A test dataset for scRecover}
\format{\itemize{
  \item counts. A non-negative integer matrix of scRNA-seq raw read counts, rows are genes and columns are cells.
  \item labels. A vector of integer specifying the cell types in the read counts matrix, corresponding to the columns of \code{counts}.
  \item oneCell. A non-negative vector of scRNA-seq raw read counts of a cell for each gene.
}}
\source{
Petropoulos S, et al. Cell, 2016, 165(4): 1012-1026.
}
\usage{
data(scRecoverTest)
}
\description{
A test dataset containing a single-cell RNA-seq (scRNA-seq) read counts matrix and its cell type information.
}
\details{
\itemize{
  \item counts. A matrix of raw read counts of scRNA-seq data which has 200 genes (rows) and 150 cells (columns).
  \item labels. A vector of integer specifying the two cell types in \code{counts}. Also could be generated by: \code{labels <- c(rep(1,50), rep(2,100))}.
  \item oneCell. A vector of a cell's raw read counts for 24538 gene.
}
}
\examples{
# Load test data for scRecover
data(scRecoverTest)


}
\seealso{
\code{\link{scRecover}}, for imputation of single-cell RNA-seq data.

\code{\link{estDropoutNum}}, for estimating dropout gene number in a cell.

\code{\link{countsSampling}}, for downsampling the read counts in a cell.

\code{\link{normalization}}, for normalization of single-cell RNA-seq data.
}
\keyword{data}
