% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_scPipeCPP.R
\name{sc_count_aligned_bam}
\alias{sc_count_aligned_bam}
\title{sc_count_aligned_bam}
\usage{
sc_count_aligned_bam(
  inbam,
  outbam,
  annofn,
  bam_tags = list(am = "YE", ge = "GE", bc = "BC", mb = "OX"),
  bc_len = 8,
  UMI_len = 6,
  stnd = TRUE,
  fix_chr = FALSE,
  outdir,
  bc_anno,
  max_mis = 1,
  mito = "MT",
  has_UMI = TRUE,
  UMI_cor = 1,
  gene_fl = FALSE,
  keep_mapped_bam = TRUE,
  nthreads = 1
)
}
\arguments{
\item{inbam}{input aligned bam file. can have multiple files as input}

\item{outbam}{output bam filename}

\item{annofn}{single string or vector of gff3 annotation filenames,
data.frame in SAF format or GRanges object containing complete gene_id
metadata column.}

\item{bam_tags}{list defining BAM tags where mapping information is
stored.
\itemize{
  \item "am": mapping status tag
  \item "ge": gene id
  \item "bc": cell barcode tag
  \item "mb": molecular barcode tag
}}

\item{bc_len}{total barcode length}

\item{UMI_len}{UMI length}

\item{stnd}{TRUE to perform strand specific mapping. (default: TRUE)}

\item{fix_chr}{TRUE to add `chr` to chromosome names, MT to chrM. (default: FALSE)}

\item{outdir}{output folder}

\item{bc_anno}{barcode annotation, first column is cell id, second column
is cell barcode sequence}

\item{max_mis}{maximum mismatch allowed in barcode. (default: 1)}

\item{mito}{mitochondrial chromosome name.
This should be consistent with the chromosome names in the bam file.}

\item{has_UMI}{whether the protocol contains UMI (default: TRUE)}

\item{UMI_cor}{correct UMI sequencing error: 0 means no correction, 1 means
simple correction and merge UMI with distance 1. 2 means merge on both UMI
alignment position match.}

\item{gene_fl}{whether to remove low abundance genes. A gene is considered to
have low abundance if only one copy of one UMI is associated with it.}

\item{keep_mapped_bam}{TRUE if feature mapped bam file should be retained.}

\item{nthreads}{number of threads to use. (default: 1)}
}
\value{
no return
}
\description{
Wrapper to run \code{\link{sc_exon_mapping}},
  \code{\link{sc_demultiplex}} and \code{\link{sc_gene_counting}} with a
  single command
}
\examples{
\dontrun{
sc_count_aligned_bam(
  inbam = "aligned.bam",
  outbam = "mapped.bam",
  annofn = c("MusMusculus-GRCm38p4-UCSC.gff3", "ERCC92_anno.gff3"),
  outdir = "output",
  bc_anno = "barcodes.csv"
)
}

}
