% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{plot_mapping}
\alias{plot_mapping}
\title{Plot mapping statistics for \code{SingleCellExperiment} object.}
\usage{
plot_mapping(sce, sel_col = NULL, percentage = FALSE, dataname = "")
}
\arguments{
\item{sce}{a \code{SingleCellExperiment} object}

\item{sel_col}{a vector of column names, indicating the columns to use for
plot. by default it will be the mapping result.}

\item{percentage}{TRUE to convert the number of reads to percentage}

\item{dataname}{the name of this dataset, used as plot title}
}
\value{
a ggplot2 object
}
\description{
Plot mapping statistics for \code{SingleCellExperiment} object.
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

plot_mapping(sce,percentage=TRUE,dataname="sc_sample")

}
