% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_workflow.R
\name{create_sce_by_dir}
\alias{create_sce_by_dir}
\title{create a SingleCellExperiment object from data folder generated by preprocessing step}
\usage{
create_sce_by_dir(
  datadir,
  organism = NULL,
  gene_id_type = NULL,
  pheno_data = NULL,
  report = FALSE
)
}
\arguments{
\item{datadir}{the directory that contains all the data and `stat` subfolder.}

\item{organism}{the organism of the data. List of possible names can be retrieved using the function
`listDatasets`from `biomaRt` package. (i.e `mmusculus_gene_ensembl` or `hsapiens_gene_ensembl`)}

\item{gene_id_type}{gene id type of the data A possible list of ids can be retrieved using the function `listAttributes` from `biomaRt` package.
the commonly used id types are `external_gene_name`, `ensembl_gene_id` or `entrezgene`}

\item{pheno_data}{the external phenotype data that linked to each single cell. This should be an \code{AnnotatedDataFrame} object}

\item{report}{whether to generate the html report in the data folder}
}
\value{
a SingleCellExperiment object
}
\description{
after we run \code{sc_gene_counting} and finish the preprocessing step. \code{create_sce_by_dir}
can be used to generate the \link{SingleCellExperiment} object from the folder that contains gene count matrix and QC statistics.
it can also generate the html report based on the gene count and quality control statistics
}
\details{
after we run \code{sc_gene_counting} and finish the preprocessing step. \code{create_sce_by_dir}
can be used to generate the SingleCellExperiment object from the folder that contains gene count matrix and QC statistics.
}
\examples{
\dontrun{
# the sce can be created fron the output folder of scPipe
# please refer to the vignettes
sce = create_sce_by_dir(datadir="output_dir_of_scPipe",
    organism="mmusculus_gene_ensembl",
    gene_id_type="ensembl_gene_id")
}
# or directly from the gene count and quality control matrix:
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication
dim(sce)

}
