% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scPCA.R
\name{cvSelectParams}
\alias{cvSelectParams}
\title{Fold-Specific Selection of Contrastive and Penalization Parameters}
\usage{
cvSelectParams(
  fold,
  target,
  background,
  center,
  scale,
  n_eigen,
  alg = alg,
  contrasts,
  penalties,
  clust_method,
  n_centers,
  max_iter,
  linkage_method,
  n_medoids,
  parallel,
  clusters,
  eigdecomp_tol,
  eigdecomp_iter,
  scaled_matrix
)
}
\arguments{
\item{fold}{Object specifying cross-validation folds as generated by a call
to \code{\link[origami]{make_folds}}.}

\item{target}{The target (experimental) data set, in a standard format such
as a \code{data.frame} or \code{matrix}.}

\item{background}{The background data set, in a standard format such as a
\code{data.frame} or \code{matrix}. Note that the number of features must
match the number of features in the target data.}

\item{center}{A \code{logical} indicating whether the target and background
data sets should be centered to mean zero.}

\item{scale}{A \code{logical} indicating whether the target and background
data sets should be scaled to unit variance.}

\item{n_eigen}{A \code{numeric} indicating the number of eigenvectors (or
sparse contrastive components) to be computed. The default is to compute
two such eigenvectors.}

\item{alg}{A \code{character} indicating the SPCA algorithm used to sparsify
the contrastive loadings. Currently supports \code{iterative} for the
\insertCite{zou2006sparse;textual}{scPCA} implementation, \code{var_proj}
for the non-randomized \insertCite{erichson2018sparse;textual}{scPCA}
solution, and \code{rand_var_proj} for the randomized
\insertCite{erichson2018sparse;textual}{scPCA} result.}

\item{contrasts}{A \code{numeric} vector of the contrastive parameters. Each
element must be a unique non-negative real number. The default is to use 40
logarithmically spaced values between 0.1 and 1000.}

\item{penalties}{A \code{numeric} vector of the L1 penalty terms on the
loadings. The default is to use 20 equidistant values between 0.05 and 1.}

\item{clust_method}{A \code{character} specifying the clustering method to
use for choosing the optimal contrastive parameter. Currently, this is
limited to either k-means, partitioning around medoids (PAM), and
hierarchical clustering. The default is k-means clustering.}

\item{n_centers}{A \code{numeric} giving the number of centers to use in the
clustering algorithm. If set to 1, cPCA, as first proposed by Abid et al.,
is performed, regardless of what the \code{penalties} argument is set to.}

\item{max_iter}{A \code{numeric} giving the maximum number of iterations to
be used in k-means clustering, defaulting to 10.}

\item{linkage_method}{A \code{character} specifying the agglomerative
linkage method to be used if \code{clust_method = "hclust"}. The options
are \code{ward.D2}, \code{single}, \code{complete}, \code{average},
\code{mcquitty}, \code{median}, and \code{centroid}. The default is
\code{complete}.}

\item{n_medoids}{A \code{numeric} indicating the number of medoids to
consider if \code{n_centers} is set to 1. The default is 8 such medoids.}

\item{parallel}{A \code{logical} indicating whether to invoke parallel
processing via the \pkg{BiocParallel} infrastructure. The default is
\code{FALSE} for sequential evaluation.}

\item{clusters}{A \code{numeric} vector of cluster labels for observations in
the \code{target} data. Defaults to \code{NULL}, but is otherwise used to
identify the optimal set of hyperparameters when fitting the scPCA and the
automated version of cPCA.}

\item{eigdecomp_tol}{A \code{numeric} providing the level of precision used by
eigendecompositon calculations. Defaults to \code{1e-10}.}

\item{eigdecomp_iter}{A \code{numeric} indicating the maximum number of
interations performed by eigendecompositon calculations. Defaults to
\code{1000}.}

\item{scaled_matrix}{A \code{logical} indicating whether to output a
\code{\link[ScaledMatrix]{ScaledMatrix}} object. The centering and scaling
procedure is delayed until later, permitting more efficient matrix
multiplication and row or column sums downstream. However, this comes at the
at the cost of numerical precision.}
}
\value{
Output structure matching either that of \code{\link{fitCPCA}} or
 \code{\link{fitGrid}} (or their parallelized variants, namely either
 \code{\link{bpFitCPCA}} and \code{link{bpFitGrid}}, respectively).
}
\description{
A wrapper function for fitting various internal functions to
 select the optimal setting of the contrastive and penalization parameters
 via cross-validation. For internal use only.
}
\references{
\insertAllCited{}
}
\keyword{internal}
