% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrastiveCov.R
\name{contrastiveCov}
\alias{contrastiveCov}
\title{Contrastive Covariance Matrices}
\usage{
contrastiveCov(
  target,
  background,
  contrasts,
  center,
  scale,
  scaled_matrix = FALSE
)
}
\arguments{
\item{target}{The target (experimental) data set, in a standard format such
as a \code{data.frame} or \code{matrix}.}

\item{background}{The background data set, in a standard format such as a
\code{data.frame} or \code{matrix}.}

\item{contrasts}{A \code{numeric} vector of the contrastive parameters.}

\item{center}{A \code{logical} indicating whether the target and background
data sets should be centered to mean zero.}

\item{scale}{A \code{logical} indicating whether the target and background
data sets should be scaled to unit variance.}

\item{scaled_matrix}{A \code{logical} indicating whether to output a
\code{\link[ScaledMatrix]{ScaledMatrix}} object. The centering and scaling
procedure is delayed until later, permitting more efficient matrix
multiplication and row or column sums downstream. However, this comes at the
at the cost of numerical precision. Defaults to \code{FALSE}.}
}
\value{
A list of contrastive covariance matrices. Each element has an
  associated contrastive parameter in the \code{contrasts} vector.
}
\description{
Compute the list of contrastive covariance matrices.
}
\keyword{internal}
