% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scMerge2h.R
\name{scMerge2h}
\alias{scMerge2h}
\title{Perform the scMerge2 (hierarchical) algorithm}
\usage{
scMerge2h(
  exprsMat,
  batch_list = list(),
  h_idx_list = list(),
  cellTypes = NULL,
  condition = NULL,
  ctl = rownames(exprsMat),
  chosen.hvg = NULL,
  ruvK_list = 20,
  use_bpparam = BiocParallel::SerialParam(),
  use_bsparam = BiocSingular::RandomParam(),
  use_bnparam = BiocNeighbors::AnnoyParam(),
  pseudoBulk_fn = "create_pseudoBulk",
  k_pseudoBulk = 30,
  k_celltype = 10,
  exprsMat_counts = NULL,
  cosineNorm = TRUE,
  return_subset = FALSE,
  return_subset_genes = NULL,
  return_matrix = TRUE,
  verbose = TRUE,
  seed = 1
)
}
\arguments{
\item{exprsMat}{A gene (row) by cell (column) log-transformed matrix to be adjusted.}

\item{batch_list}{A list indicating the batch information for each cell in the batch-combined matrix.}

\item{h_idx_list}{A list indicating the indeces information in the hierarchical merging.}

\item{cellTypes}{An optional vector indicating the cell type information for each cell in the batch-combined matrix. 
If it is \code{NULL}, pseudo-replicate procedure will be run to identify cell type.}

\item{condition}{An optional vector indicating the condition information for each cell in the batch-combined matrix.}

\item{ctl}{A character vector of negative control. It should have a non-empty intersection with the rows of exprsMat}

\item{chosen.hvg}{An optional character vector of highly variable genes chosen.}

\item{ruvK_list}{An integer indicates the number of unwanted variation factors that are removed, default is 20.}

\item{use_bpparam}{A \code{BiocParallelParam} class object from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{use_bsparam}{A \code{BiocSingularParam} class object from the \code{BiocSingular} package is used. Default is RandomParam().}

\item{use_bnparam}{A \code{BiocNeighborsParam} class object from the \code{BiocNeighbors} package is used. Default is AnnoyParam().}

\item{pseudoBulk_fn}{A character indicates the way of pseudobulk constructed.}

\item{k_pseudoBulk}{An integer indicates the number of pseudobulk constructed within each cell grouping. Default is 30.}

\item{k_celltype}{An integer indicates the number of nearest neighbours used in \code{buildSNNGraph} when grouping cells within each batch. Default is 10.}

\item{exprsMat_counts}{A gene (row) by cell (column) counts matrix to be adjusted.}

\item{cosineNorm}{A logical vector indicates whether cosine normalisation is performed on input data.}

\item{return_subset}{If \code{TRUE}, adjusted matrix of only a subset of genes (hvg or indicates in \code{return_subset_genes}) will be return.}

\item{return_subset_genes}{An optional character vector of indicates the subset of genes will be adjusted.}

\item{return_matrix}{A logical vector indicates whether the adjusted matrix is calculated and returned. 
If \code{FALSE}, then only the estimated parameters will be returned.}

\item{verbose}{If \code{TRUE}, then all intermediate steps will be shown. Default to \code{FALSE}.}

\item{seed}{A numeric input indicates the seed used.}
}
\description{
Merge single-cell data hierarchically from different batches and experiments 
leveraging (pseudo)-replicates, control genes and pseudo-bulk.
}
\examples{

## Loading example data
data('example_sce', package = 'scMerge')
## Previously computed stably expressed genes
data('segList_ensemblGeneID', package = 'scMerge')


# Create a fake sample information
example_sce$sample <- rep(c(1:4), each = 50)

# Construct a hierarchical index list
h_idx_list <- list(level1 = split(1:200, example_sce$batch),
                   level2 = list(1:200))

# Construct a batch information list
batch_list <- list(level1 = split(example_sce$sample, example_sce$batch),
                   level2 = list(example_sce$batch))
library(SingleCellExperiment)
exprsMat <- scMerge2h(exprsMat = logcounts(example_sce),
batch_list = batch_list,
h_idx_list = h_idx_list,
ctl = segList_ensemblGeneID$mouse$mouse_scSEG,
ruvK_list = c(2, 5))
assay(example_sce, "scMerge2") <- exprsMat[[length(h_idx_list)]]
example_sce = scater::runPCA(example_sce, exprs_values = 'scMerge2')                                       
scater::plotPCA(example_sce, colour_by = 'cellTypes', shape = 'batch')
}
\author{
Yingxin Lin
}
