% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherOrderFunctions.R
\name{weightedZISpearman}
\alias{weightedZISpearman}
\title{weightedZISpearman}
\usage{
weightedZISpearman(x, y, w = 1)
}
\arguments{
\item{x}{x and y are non-negative data vectors}

\item{y}{x and y are non-negative data vectors}

\item{w}{weight vector, values should be between 0 and 1}
}
\value{
\code{numeric} weighted rho* association value between x and y

 Pimentel, Ronald Silva, "Kendall's Tau and Spearman's Rho for
 Zero-Inflated Data" (2009). Dissertations. 721.
 https://scholarworks.wmich.edu/dissertations/721
}
\description{
the weightedZISpearman function calculates weighted rho\*,
where rho\* is described in Pimentel et al (2009).
This association measure is defined for zero-inflated,
non-negative random variables.
}
\examples{

x = pmax(0,rnorm(100))
y = pmax(0,rnorm(100))
w = runif(100)
weightedZISpearman(x,y,w)

}
