% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{scHOT_buildFromMatrix}
\alias{scHOT_buildFromMatrix}
\title{scHOT_buildFromMatrix}
\usage{
scHOT_buildFromMatrix(
  mat,
  cellData = NULL,
  positionType = NULL,
  positionColData = NULL
)
}
\arguments{
\item{mat}{A matrix with rows for genes and columns for cells}

\item{cellData}{A dataframe or DataFrame object with rows for cells}

\item{positionType}{A string indicating the position type,
either "trajectory" or "spatial"}

\item{positionColData}{Strings indicate the position information
stored in colData. If positionType is "trajectory" then
positionColData should be a sortable vector
if positionType is "spatial" then positionColData should
be a matrix type object.}
}
\value{
A scHOT object
}
\description{
Create scHOT object from a matrix
}
\examples{

dat <- rbind(rnorm(50), rnorm(50), rnorm(50))
colnames(dat) <- paste0("cell_", 1:ncol(dat))
rownames(dat) <- c("gene_1","gene_2", "gene_2")

scHOT <- scHOT_buildFromMatrix(dat, cellData = data.frame(1:ncol(dat)))

}
