% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb_adjacency.R
\name{stringdb_adjacency}
\alias{stringdb_adjacency}
\title{Build Adjacency Matrices for Physical Interactions from STRING (POST API)}
\usage{
stringdb_adjacency(
  genes,
  species = 9606,
  required_score = 400,
  keep_all_genes = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{genes}{A character vector of gene symbols or identifiers, e.g.,
\code{c("TP53", "BRCA1", ...)}.}

\item{species}{Integer. NCBI taxonomy ID of the species. Default is
\code{9606} (human).}

\item{required_score}{Integer in \[0,1000\]. Minimum confidence score for
interactions. Default is \code{400}.}

\item{keep_all_genes}{Logical. If \code{TRUE} (default), includes all input
genes in the final matrix even if unmapped.}

\item{verbose}{Logical. If \code{TRUE}, displays progress messages. Default
is \code{TRUE}.}
}
\value{
A list containing:
\itemize{
\item \code{weighted}: A square numeric adjacency matrix with scores as
weights.
\item \code{binary}: A corresponding binary (0/1) adjacency matrix.
}
}
\description{
Constructs weighted and binary adj matrices for physical protein-protein
interactions using a POST request to the STRING database API.
}
\details{
This function:
\enumerate{
\item Maps input genes to STRING internal IDs.
\item Uses a POST request to retrieve physical protein-protein
interactions from STRING.
\item Builds a weighted adjacency matrix using the STRING combined score.
\item Builds a binary adjacency matrix indicating presence/absence.
}

Genes not mapped to STRING are optionally retained as zero rows/columns if
\code{keep_all_genes = TRUE}.
}
\note{
Requires packages: \pkg{STRINGdb}, \pkg{httr}, \pkg{jsonlite}.
}
\examples{
data(toy_counts)
genes <- selgene(
    object = toy_counts[[1]],
    top_n = 5,
    cell_type = "T_cells",
    cell_type_col = "CELL_TYPE",
    remove_rib = TRUE,
    remove_mt = TRUE,
    assay = "counts"
)

str_res <- stringdb_adjacency(
    genes = genes,
    species = 9606,
    required_score = 900,
    keep_all_genes = FALSE
)
wadj_truth <- str_res$weighted
toy_adj_matrix <- str_res$binary
}
