% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDotPlot.R
\name{scDotPlot}
\alias{scDotPlot}
\alias{scDotPlot.SingleCellExperiment}
\alias{scDotPlot.Seurat}
\alias{scDotPlot.default}
\title{scDotPlot}
\usage{
\method{scDotPlot}{SingleCellExperiment}(
  object,
  features = features,
  group = NULL,
  block = NULL,
  swap_rownames = NULL,
  scale = FALSE,
  cluster = TRUE,
  clusterRows = cluster,
  clusterColumns = cluster,
  AverageThreshold = ifelse(scale == FALSE, 0, -Inf),
  NumDetectedThreshold = 0.01,
  groupAnno = FALSE,
  featureAnno = FALSE,
  treeWidth = 0.1,
  treeHeight = 0.1,
  annoWidth = 0.05,
  annoHeight = 0.02,
  annoColors = NULL,
  dotColors = NULL,
  groupLegends = TRUE,
  featureLegends = TRUE,
  fontSize = 11,
  fontFamily = "",
  flipPlot = FALSE,
  ...
)

\method{scDotPlot}{Seurat}(
  object,
  features = features,
  group = NULL,
  block = NULL,
  swap_rownames = NULL,
  scale = FALSE,
  cluster = TRUE,
  clusterRows = cluster,
  clusterColumns = cluster,
  AverageThreshold = ifelse(scale == FALSE, 0, -Inf),
  NumDetectedThreshold = 0.01,
  groupAnno = FALSE,
  featureAnno = FALSE,
  treeWidth = 0.1,
  treeHeight = 0.1,
  annoWidth = 0.05,
  annoHeight = 0.02,
  annoColors = NULL,
  dotColors = NULL,
  groupLegends = TRUE,
  featureLegends = TRUE,
  fontSize = 11,
  fontFamily = "",
  flipPlot = FALSE,
  ...
)

\method{scDotPlot}{default}(
  object,
  features = NULL,
  group = NULL,
  block = NULL,
  swap_rownames = NULL,
  scale = FALSE,
  cluster = TRUE,
  clusterRows = cluster,
  clusterColumns = cluster,
  AverageThreshold = ifelse(scale == FALSE, 0, -Inf),
  NumDetectedThreshold = 0.01,
  groupAnno = FALSE,
  featureAnno = FALSE,
  treeWidth = 0.1,
  treeHeight = 0.1,
  annoWidth = 0.05,
  annoHeight = 0.02,
  annoColors = NULL,
  dotColors = NULL,
  groupLegends = TRUE,
  featureLegends = TRUE,
  fontSize = 11,
  fontFamily = "",
  flipPlot = FALSE,
  ...
)

scDotPlot(object, ...)
}
\arguments{
\item{object}{An object with normalized data
\itemize{
\item \link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment}
\item \link[SeuratObject:Seurat-class]{Seurat}
\item A data.frame with the following columns: "NumDetected", "Feature", "Group", "Average"
}}

\item{features}{Character vector with genes of interest}

\item{group}{Column name from colData/metadata of the object to group cells by}

\item{block}{Column name from colData of a SingleCellExperiment object
to use as a blocking factor (e.g. batch or sample)}

\item{swap_rownames}{Column name from rowData of a SingleCellExperiment
object to match to features}

\item{scale}{Logical indicating whether the data should be scaled and centered}

\item{cluster}{Logical specifying whether to perform hierarchical clustering
analysis on both the rows and columns}

\item{clusterRows}{Logical specifying whether to perform hierarchical clustering
analysis on the rows}

\item{clusterColumns}{Logical specifying whether to perform hierarchical clustering
analysis on the columns}

\item{AverageThreshold}{Numeric specifying threshold for average expression,
where values below AverageThreshold and NumDetectedThreshold are transparent}

\item{NumDetectedThreshold}{Numeric specifying threshold for fraction of cells,
where values below AverageThreshold and NumDetectedThreshold are transparent}

\item{groupAnno}{Cell annotations that are stored as names of columns
in colData of sce with annotations}

\item{featureAnno}{Feature annotations that are stored as names of rows
in rowData of sce with annotations}

\item{treeWidth}{Numeric specifying width of the row tree relative to
the dotPlot}

\item{treeHeight}{Numeric specifying height of the column tree relative to
the dotPlot}

\item{annoWidth}{Numeric specifying the width of the row annotation relative
to the dotPlot}

\item{annoHeight}{Numeric specifying height of the column annotation relative
to the dotPlot}

\item{annoColors}{A list with a name for each annotation that contains
a named vector of colors, where the name is the pairing of values to colors}

\item{dotColors}{A character vector specifying the colors to be used
in the gradient for the dots. If scale is set to TRUE, the first 3 colors
will be used for the negative, zero, and positive values, respectively.}

\item{groupLegends}{Logical indicating whether to show legends for group
annotations}

\item{featureLegends}{Logical indicating whether to show legends for feature
annotations}

\item{fontSize}{Numeric specifying the base font size in pts}

\item{fontFamily}{Character specifying the base font family}

\item{flipPlot}{Logical indicating whether to flip the x and y coordinates}

\item{...}{Additional unused arguments}
}
\value{
\itemize{
\item When \code{cluster = TRUE}, a \code{aplot} object
\item When \code{cluster = FALSE}, a \code{ggplot2} object
}
}
\description{
Create dot plot of gene expression profiles that can be
annotated with hierarchical clustering from \link[ggtree]{ggtree} using
\link[aplot:plot-insertion]{aplot}
}
\details{
The data for the dot plot is generated from different sources
depending on the object:
\itemize{
\item \code{SingleCellExperiment:} \link[scater]{plotDots}
\item \code{Seurat:} \link[Seurat]{DotPlot}
}
}
\examples{
data("pbmc_small", package = "SeuratObject")
pbmc_small |>
    scDotPlot(features = Seurat::VariableFeatures(pbmc_small),
              group = "RNA_snn_res.1")
}
\references{
\url{https://yulab-smu.top/pkgdocs/aplot.html#a-single-cell-example}
}
