% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.annotateDotPlot}
\alias{.annotateDotPlot}
\title{Cluster Dot Plot}
\usage{
.annotateDotPlot(
  dotPlot,
  clusterRows = TRUE,
  clusterColumns = TRUE,
  groupAnno = FALSE,
  featureAnno = FALSE,
  treeWidth = 0.1,
  treeHeight = 0.1,
  annoWidth = 0.05,
  annoHeight = 0.02,
  annoColors = NULL,
  groupLegends = TRUE,
  featureLegends = TRUE,
  fontSize = 11,
  fontFamily = "",
  flipPlot = FALSE
)
}
\arguments{
\item{clusterRows}{Logical specifying whether to perform hierarchical clustering
analysis on the rows}

\item{clusterColumns}{Logical specifying whether to perform hierarchical clustering
analysis on the columns}

\item{groupAnno}{Cell annotations that are stored as names of columns
in colData of sce with annotations}

\item{featureAnno}{Feature annotations that are stored as names of rows
in rowData of sce with annotations}

\item{treeWidth}{Numeric specifying width of the row tree relative to
the dotPlot}

\item{treeHeight}{Numeric specifying height of the column tree relative to
the dotPlot}

\item{annoWidth}{Numeric specifying the width of the row annotation relative
to the dotPlot}

\item{annoHeight}{Numeric specifying height of the column annotation relative
to the dotPlot}

\item{annoColors}{A list with a name for each annotation that contains
a named vector of colors, where the name is the pairing of values to colors}

\item{groupLegends}{Logical indicating whether to show legends for group
annotations}

\item{featureLegends}{Logical indicating whether to show legends for feature
annotations}

\item{fontSize}{Numeric specifying the base font size in pts}

\item{fontFamily}{Character specifying the base font family}

\item{flipPlot}{Logical indicating whether to flip the x and y coordinates}
}
\value{
A aplot
}
\description{
Cluster Dot Plot
}
\keyword{internal}
