% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{cxds2}
\alias{cxds2}
\title{cxds2}
\usage{
cxds2(x, whichDbls = c(), ntop = 500, binThresh = NULL)
}
\arguments{
\item{x}{A matrix of counts, or a `SingleCellExperiment` containing a
'counts'}

\item{whichDbls}{The columns of `x` which are known doublets.}

\item{ntop}{The number of top features to keep.}

\item{binThresh}{The count threshold to be considered expressed.}
}
\value{
A cxds score or, if `x` is a `SingleCellExperiment`, `x` with an
  added `cxds_score` colData column.
}
\description{
Calculates a coexpression-based doublet score using the method developed by
\href{https://doi.org/10.1093/bioinformatics/btz698}{Bais and Kostka 2020}.
This is the original implementation from the
\href{https://www.bioconductor.org/packages/release/bioc/html/scds.html}{scds}
package, but enabling scores to be calculated for all cells while the gene
coexpression is based only on a subset (i.e. excluding known/artificial 
doublets) and making it robust to low sparsity.
}
\examples{
sce <- mockDoubletSCE()
sce <- cxds2(sce)
# which is equivalent to
# sce$cxds_score <- cxds2(counts(sce))
}
\references{
\url{https://doi.org/10.1093/bioinformatics/btz698}
}
