% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSignatures.R
\name{plotSignatures}
\alias{plotSignatures}
\title{Find enriched markers per identified cluster and visualise these as a custom corrplot.}
\usage{
plotSignatures(
  indata,
  assay = "scaled",
  clusterAssign = metadata(indata)[["Cluster"]],
  funcSummarise = function(x) mean(x, na.rm = TRUE),
  col = colorRampPalette(brewer.pal(9, "RdPu"))(100),
  labCex = 1,
  legendPosition = "right",
  legendCex = 1,
  labDegree = 90,
  verbose = TRUE
)
}
\arguments{
\item{indata}{A data-frame or matrix, or \code{SingleCellExperiment} object. If a
data-frame or matrix, this should relate to expression data (cells as
columns; genes as rows). If a \code{SingleCellExperiment} object, data will be
extracted from an assay component named by \code{assay}.}

\item{assay}{Name of the assay slot in \code{indata} from which data will be
taken, assuming \code{indata} is a \code{SingleCellExperiment} object.}

\item{clusterAssign}{A vector of cell-to-cluster assignments. This can be
from any source but must align with your cells / variables. There is no
check to ensure this when \code{indata} is not a \code{SingleCellExperiment} object.}

\item{funcSummarise}{A mathematical function used to summarise expression
per marker, per cluster.}

\item{col}{colorRampPalette to be used for shading low-to-high expression.}

\item{labCex}{cex (size) of the main plot labels.}

\item{legendPosition}{position of legend. Can be one of 'top', 'right', 'bottom', 'left'}

\item{legendCex}{cex (size) of the legend labels.}

\item{labDegree}{Rotation angle of the main plot labels.}

\item{verbose}{Boolean (TRUE / FALSE) to print messages to console or not.}
}
\value{
A \code{corrplot} object.
}
\description{
Find enriched markers per identified cluster and visualise these as a custom corrplot.
}
\details{
Find enriched markers per identified cluster and visualise these as a custom corrplot. \code{plotSignatures} first collapses your input data's expression profiles from the level of cells to the level of clusters based on a mathematical function specified by \code{funcSummarise}. It then centers and scales the data range to be between -1 and +1 for visualisation purposes.
}
\examples{
# create random data that follows a negative binomial
mat <- jitter(matrix(
  MASS::rnegbin(rexp(1000, rate=.1), theta = 4.5),
  ncol = 20))
colnames(mat) <- paste0('CD', 1:ncol(mat))
rownames(mat) <- paste0('cell', 1:nrow(mat))

u <- umap::umap(mat)$layout
colnames(u) <- c('UMAP1','UMAP2')
rownames(u) <- rownames(mat)
clus <- clusKNN(u)

plotSignatures(t(mat), clusterAssign = clus)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
