% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_scClassify.R
\name{predict_scClassify}
\alias{predict_scClassify}
\title{Testing scClassify model}
\usage{
predict_scClassify(
  exprsMat_test,
  trainRes,
  cellTypes_test = NULL,
  k = 10,
  prob_threshold = 0.7,
  cor_threshold_static = 0.5,
  cor_threshold_high = 0.7,
  features = "limma",
  algorithm = "WKNN",
  similarity = "pearson",
  cutoff_method = c("dynamic", "static"),
  weighted_ensemble = FALSE,
  weights = NULL,
  parallel = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{exprsMat_test}{A list or a matrix indicates the log-transformed
expression matrices of the query datasets}

\item{trainRes}{A `scClassifyTrainModel` or a `list` indicates
scClassify trained model}

\item{cellTypes_test}{A list or a vector indicates cell types
of the qurey datasets (Optional).}

\item{k}{An integer indicates the number of neighbour}

\item{prob_threshold}{A numeric indicates the probability threshold
for KNN/WKNN/DWKNN.}

\item{cor_threshold_static}{A numeric indicates the static
correlation threshold.}

\item{cor_threshold_high}{A numeric indicates the highest
correlation threshold}

\item{features}{A vector indicates the gene selection method,
set as "limma" by default.
This should be one or more of "limma", "DV", "DD", "chisq", "BI".}

\item{algorithm}{A vector indicates the KNN method that are used,
set as "WKNN" by default.
This should be one or more of "WKNN", "KNN", "DWKNN".}

\item{similarity}{A vector indicates the similarity measure that are used,
set as "pearson" by default.
This should be one or more of "pearson",  "spearman", "cosine",
"jaccard", "kendall", "binomial", "weighted_rank","manhattan"}

\item{cutoff_method}{A vector indicates the method to cutoff the
correlation distribution. Set as "dynamic" by default.}

\item{weighted_ensemble}{A logical input indicates in ensemble learning,
whether the results is combined by a
weighted score for each base classifier.}

\item{weights}{A vector indicates the weights for ensemble}

\item{parallel}{A logical input indicates whether running in paralllel or not}

\item{BPPARAM}{A \code{BiocParallelParam} class object
from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{verbose}{A logical input indicates whether the intermediate steps
will be printed}
}
\value{
list of results
}
\description{
Testing scClassify model
}
\examples{
data("scClassify_example")
wang_cellTypes <- scClassify_example$wang_cellTypes
exprsMat_wang_subset <- scClassify_example$exprsMat_wang_subset
data("trainClassExample_xin")

pred_res <- predict_scClassify(exprsMat_test = exprsMat_wang_subset,
trainRes = trainClassExample_xin,
cellTypes_test = wang_cellTypes,
algorithm = "WKNN",
features = c("limma"),
similarity = c("pearson"),
prob_threshold = 0.7,
verbose = TRUE)

}
\author{
Yingxin Lin
}
