% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CheckBackgroundCutoff.R
\name{CheckBackgroundCutoff}
\alias{CheckBackgroundCutoff}
\title{Check different background cutoffs and recommend an appropriate one}
\usage{
CheckBackgroundCutoff(RawDat)
}
\arguments{
\item{RawDat}{Matrix. Supports standard matrix or sparse matrix. 
This is the raw feature-by-barcode count matrix.}
}
\value{
A list containing a data frame summarizing background information 
under different background cutoffs, and the recommended background cutoff 
for the input data. For the data frame, `n_bg_bcs` is the number of 
barcodes less or equal to the cutoff, `n_bg_counts` is the number of UMI 
counts within the barcodes less or equal to the cutoff, 
`prop_bg_bcs` and `prop_bg_counts` are the corresponding proportions.
}
\description{
The key parameter of CB2 as well as other similar methods is the 
background cutoff, which divides barcodes 
into two groups: (1) small barcodes that are most likely to be 
background; (2) the rest barcodes that can be either background or cell, and 
remain to be tested. Those small barcodes will be used to estimate a 
background distribution, which guides the identification of cells from 
background. It is crucial to have an unbiased estimation of the background 
distribution.
}
\details{
An appropriate background cutoff should be reasonably large to contain 
enough background information, but shouldn't be too large to mistakenly 
include real cells. We recommend a background cutoff which 
(1) puts more than 90% barcodes into background, or 
(2) puts more than 10% UMI counts into background. 
The smallest cutoff satisfying either condition is the recommended cutoff.
}
\examples{
data(mbrainSub)
CheckBackgroundCutoff(mbrainSub)

}
