% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFA.R
\name{InitBinaryFA}
\alias{InitBinaryFA}
\title{This function should be called to initialize input parameters into the
main scBFA function}
\usage{
InitBinaryFA(
  modelEnv,
  GeneExpr,
  numFactors,
  epsilon,
  X = NULL,
  Q = NULL,
  initCellcoef,
  updateCellcoef,
  updateGenecoef,
  NUM_CELLS_PER_CHUNK = min(ncol(GeneExpr), 50000),
  doChunking = (NUM_CELLS_PER_CHUNK < modelEnv$numCells)
)
}
\arguments{
\item{modelEnv}{Empty R environment variable to contain following parameters:
{A,Z,V,U,\eqn{\beta},\eqn{\gamma},\eqn{\epsilon}}}

\item{GeneExpr}{G by N rawcount matrix,
in which rows are genes and columns are cells}

\item{numFactors}{Numeric value, number of latent dimensions}

\item{epsilon}{Numeric value, parameter to control the strength of
regularization}

\item{X}{N by C cell-specific covariate matrix(e.g batch effect),
in which rows are cells,columns are number of covariates.
 If no such covariates are available, then X = NULL}

\item{Q}{G by T gene-specific covariate matrix(e.g quality control measures),
in which rows are genes columns are number of covariates,
If no such covariates are available, then Q = NULL}

\item{initCellcoef}{Initialization of C by G gene-specific coefficient matrix
as user-defined coefficient \eqn{\beta}.
Such user defined coefficient can be applied to address confounding batch
effect}

\item{updateCellcoef}{Logical value, parameter to decide whether to
update C by G gene-specific coefficient matrix.
Again, when the cell types are confounded with technical batches or
there is no cell level covariate matrix,
the user can keep the initialization of coefficients as known estimate.}

\item{updateGenecoef}{Logical value, parameter to decide whether to update
N by T gene-specific coefficient matrix.
Again, when there is no gene level covariate matrix,
this value should be FALSE by default.}

\item{NUM_CELLS_PER_CHUNK}{scBFA can run out of memory on large datasets, so
we can chunk up computations to avoid this if necessary. NUM_CELLS_PER_CHUNK
is the number of cells per 'chunk' computed. Shrink if running out of mem.}

\item{doChunking}{Use memory-efficient (but slower) chunking. Will do automatically
if the chunk size is specified to be smaller than the # of cells in dataset.}
}
\value{
A model environment containing the following parameters:
{A,Z,V,U,\eqn{\beta},\eqn{\gamma},\eqn{\epsilon}}.
}
\description{
This function should be called to initialize input parameters into the
main scBFA function
}
\keyword{internal}
