% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{cell_type}
\alias{cell_type}
\alias{cell_type<-,scAnnotatR-method}
\title{cell_type}
\usage{
cell_type(classifier)

\S4method{cell_type}{scAnnotatR}(classifier) <- value
}
\arguments{
\item{classifier}{scAnnotatR object. 
The object is returned from the train_classifier function.}

\item{value}{the new cell type}
}
\value{
cell type of object

scAnnotatR object with the new cell type
}
\description{
Returns the cell type for the given classifier.
}
\examples{
data("tirosh_mel80_example")
selected_marker_genes_B = c("CD19", "MS4A1", "CD79A")
set.seed(123)
classifier_b <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', slot = 'counts', marker_genes = selected_marker_genes_B, 
cell_type = "B cells", tag_slot = 'active.ident')
cell_type(classifier_b)

data("tirosh_mel80_example")
selected_marker_genes_B = c("CD19", "MS4A1", "CD79A")
set.seed(123)
classifier_b <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', slot = 'counts', marker_genes = selected_marker_genes_B, 
cell_type = "B cells", tag_slot = 'active.ident')
cell_type(classifier_b) <- "B cell"
}
