% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BamtoAspliCounts.R
\name{BamtoAspliCounts}
\alias{BamtoAspliCounts}
\title{Converting BAM files to an ASpli-SummarizedExperiment, which contains
gene, bin and junction counts.}
\usage{
BamtoAspliCounts(
  features,
  targets,
  minReadLength = 100,
  maxISize = 50000,
  libType = "PE",
  strandMode = 0,
  minAnchor = 0,
  threshold = 5,
  BPPARAM = bpparam()
)
}
\arguments{
\item{features}{An object of class ASpliFeatures, obtained by using the
binGenome function of ASpli.}

\item{targets}{A dataframe containing sample, bam and experimental factors
columns.}

\item{minReadLength}{Minimum read length of sequenced library. It is used
for computing E1I and IE2 read summarization. Make sure this number is
smaller than the maximum read length in every bam file, otherwise no E1I or
IE2 will be found}

\item{maxISize}{Maximum intron expected size. Junctions longer than this
size will be dicarded.}

\item{libType}{Defines how reads will be treated according their sequencing
library type (paired (PE, default) or single end (SE)).}

\item{strandMode}{controls the behavior of the strand getter. It indicates
how the strand of a pair should be inferred from the strand of the first
and last alignments in the pair. 0: strand of the pair is always *.
1: strand of the pair is strand of its first alignment.
This mode should be used when the paired-end data was generated using one of
 the following stranded protocols: Directional Illumina (Ligation), Standard
 SOLiD. 2: strand of the pair is strand of its last alignment.
 This mode should be used when the paired-end data was generated using one
 of the following stranded protocols: dUTP, NSR, NNSR, Illumina stranded
 TruSeq PE protocol. For more information see ?strandMode}

\item{minAnchor}{Minimum percentage of read that should be aligned to an
exon-intron boundary.}

\item{threshold}{Minimum number of reads supporting junctions. Default=5.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{bpparam} in \code{BiocParallel} package for details.}
}
\value{
A `SummarizedExperiment` instance, containing `gene`, `bin` and
`junction` counts in the metadata slot.
}
\description{
BamtoAspliCounts is used to convert BAM files to a SummarizedExperiment
that contains gene, bin and junction level counts in the metadata slot.
This function is adapted from the ASpli package. More information can be
found in the corresponding package and paper.
}
\examples{

data(saseRExample, package = "saseR")

bamFileNames <- paste(rep(c("A", "B"), each = 6), rep(c("C",
 "D"), 2, each = 3), paste0(rep(0:2, 2), ".bam"), sep = "_")

BAMFiles <- system.file("extdata", bamFileNames, package = "saseR")

targets <- data.frame(
    row.names = paste0('Sample',c(1:12)),
    bam = BAMFiles,
    f1 = rep("A",12),
    stringsAsFactors = FALSE)

ASpliSE <- BamtoAspliCounts(
    features = features,
    targets = targets,
    minReadLength = 100,
    libType = "SE"
)

}
