% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{sourceBlock}
\alias{sourceBlock}
\title{Identify associated input sequence for given position(s) in suffix
array}
\usage{
sourceBlock(sarks, s = NULL, i = NULL)
}
\arguments{
\item{sarks}{Sarks object from which information will be derived}

\item{s}{the spatial position(s) to query; use NULL (default value)
if you instead want to specify sorted suffix position i}

\item{i}{the position(s) in the sorted suffix list to query}
}
\value{
character vector containing name(s) of corresponding input
    sequence(s)
}
\description{
Any positiion in a suffix array for SArKS concatenated sequence can
be identified either via its position i in lexicographically sorted
list of suffixes or by its spatial position s in the concatenated
sequence. This function indicates which input sequence contributed
the block of the concatenated sequence within which the specified
position(s) can be found.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
blocks <- sarks$sourceBlock(i=2253:2261)

}
