% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{permutationDistribution}
\alias{permutationDistribution}
\title{Estimating distribution of maximum smoothed sequence scores under
permutation}
\usage{
permutationDistribution(sarks, reps, filters, seed = NULL)
}
\arguments{
\item{sarks}{Sarks object to test.}

\item{reps}{integer specifying how many repetitions to test.}

\item{filters}{output from sarksFilters function indicating what
combinations of filter parameters halfWindow, spatialLength,
and minGini to use.}

\item{seed}{optional seed for random number generator (use in case
reproducibility of output is desired).}
}
\value{
named list with three elements: `windowed' containing a
    data.frame with the maximum smoothed scores for each
    permutation at each combination of filter parameter values,
    `spatial' containing a data.frame with the maximum
    spatially-smoothed scores for each permutation and each filter
    parameter specification, and `.java' containing the R
    representation of the java object encoding this information.
}
\description{
Run permutation test using the specified number of repetitions,
keeping track of maximum observed windowed and spatially-windowed
smoothed scores for each combination of filter parameters for each
permutation.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=0, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
