% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{extendKmers}
\alias{extendKmers}
\title{Extend k-mers in length where possible}
\usage{
extendKmers(sarks, sarksTable)
}
\arguments{
\item{sarks}{Sarks object used to obtain k-mer peak call set.}

\item{sarksTable}{data.frame containing called k-mer peaks
information (format as output from kmerPeaks function).}
}
\value{
modified data.frame containing called k-mer peaks
    information (format as output from kmerPeaks function).
}
\description{
Extend k-mers when adding flanking characters from region in
input sequence from which they are derived would result in another
reported l-mer string (l > k).
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=0, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)
thresholds <- permutationThresholds(filters, permDist, nSigma=2.0)
peaks <- kmerPeaks(sarks, filters, thresholds)
prunedPeaks <- pruneIntervals(peaks)
extendedPeaks <- extendKmers(sarks, prunedPeaks)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
