/*
 * Decompiled with CFR 0.152.
 */
package dcw.sarks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class SarksUtilities {
    public static Float max(float[] fArray, boolean[] blArray) {
        if (fArray == null || fArray.length == 0) {
            return null;
        }
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (blArray[i] || !(fArray[i] > f)) continue;
            f = fArray[i];
        }
        return Float.valueOf(f);
    }

    public static int max(int[] nArray, int n) {
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        return n2;
    }

    public static Float mean(Float[] floatArray) {
        if (floatArray == null || floatArray.length == 0) {
            return null;
        }
        if (floatArray[0] == null) {
            return null;
        }
        double d = 0.0;
        for (int i = 0; i < floatArray.length; ++i) {
            d += (double)floatArray[i].floatValue();
        }
        return Float.valueOf((float)d / (float)floatArray.length);
    }

    public static Float sd(Float[] floatArray) {
        if (floatArray == null || floatArray.length == 0) {
            return null;
        }
        if (floatArray[0] == null) {
            return null;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < floatArray.length; ++i) {
            d += (double)floatArray[i].floatValue();
            d2 += (double)(floatArray[i].floatValue() * floatArray[i].floatValue());
        }
        double d3 = d / (double)floatArray.length;
        double d4 = d2 / (double)floatArray.length;
        return Float.valueOf((float)Math.sqrt((double)floatArray.length / (double)(floatArray.length - 1) * (d4 - d3 * d3)));
    }

    public static float median(float[] fArray) {
        int n;
        float[] fArray2 = new float[fArray.length];
        for (n = 0; n < fArray.length; ++n) {
            fArray2[n] = fArray[n];
        }
        Arrays.sort(fArray2);
        int n2 = n = fArray.length / 2;
        if (fArray.length > 0 && fArray.length % 2 == 0) {
            --n2;
        }
        return (float)((double)(fArray2[n] + fArray2[n2]) / 2.0);
    }

    public static Integer[][] generatePermutations(int n, int n2, Long l) {
        Random random = new Random();
        if (l != null) {
            random.setSeed(l);
        }
        Integer[][] integerArray = new Integer[n][n2];
        for (int i = 0; i < n; ++i) {
            int n3;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n3 = 0; n3 < n2; ++n3) {
                arrayList.add(n3);
            }
            Collections.shuffle(arrayList, random);
            for (n3 = 0; n3 < n2; ++n3) {
                integerArray[i][n3] = (Integer)arrayList.get(n3);
            }
        }
        return integerArray;
    }

    public static Integer[][][] partitionPermutations(Integer[][] integerArray, int n) {
        Integer[][][] integerArray2 = new Integer[n][][];
        int n2 = integerArray.length / n;
        int n3 = integerArray.length % n;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            integerArray2[i] = i < n3 ? new Integer[n2 + 1][] : new Integer[n2][];
            for (int j = 0; j < integerArray2[i].length; ++j) {
                integerArray2[i][j] = integerArray[j + n4];
            }
            n4 += integerArray2[i].length;
        }
        return integerArray2;
    }

    public static Float[][] mergeMaxResults(ArrayList<Float[][]> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            n += arrayList.get(i).length;
        }
        Float[][] floatArray = new Float[n][2];
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Float[][] floatArray2 = arrayList.get(i);
            for (int j = 0; j < floatArray2.length; ++j) {
                floatArray[j + n2][0] = floatArray2[j][0];
                floatArray[j + n2][1] = floatArray2[j][1];
            }
            n2 += floatArray2.length;
        }
        return floatArray;
    }

    public static Float[][] thresholdsFromPermutations(ArrayList<Float[][]> arrayList, float f) {
        Float[][] floatArray = new Float[arrayList.get(0).length][2];
        for (int i = 0; i < floatArray.length; ++i) {
            Float[] floatArray2 = new Float[arrayList.size()];
            Float[] floatArray3 = new Float[arrayList.size()];
            for (int j = 0; j < floatArray2.length; ++j) {
                floatArray2[j] = arrayList.get(j)[i][0];
                floatArray3[j] = arrayList.get(j)[i][1];
            }
            floatArray[i][0] = floatArray2[0] != null ? Float.valueOf(SarksUtilities.mean(floatArray2).floatValue() + f * SarksUtilities.sd(floatArray2).floatValue()) : null;
            if (floatArray3[0] != null) {
                floatArray[i][0] = null;
                floatArray[i][1] = Float.valueOf(SarksUtilities.mean(floatArray3).floatValue() + f * SarksUtilities.sd(floatArray3).floatValue());
                continue;
            }
            floatArray[i][1] = null;
        }
        return floatArray;
    }

    public static Float[][] thresholdsFromPermutations(ArrayList<Float[][]> arrayList, double d) {
        return SarksUtilities.thresholdsFromPermutations(arrayList, (float)d);
    }

    public static int falsePositives(ArrayList<Float[][]> arrayList, Float[][] floatArray) {
        int n;
        int n2;
        int[] nArray = new int[arrayList.size()];
        for (n2 = 0; n2 < floatArray.length; ++n2) {
            for (n = 0; n < arrayList.size(); ++n) {
                if (!(floatArray[n2][0] != null && arrayList.get(n)[n2][0].floatValue() >= floatArray[n2][0].floatValue()) && (floatArray[n2][1] == null || !(arrayList.get(n)[n2][1].floatValue() >= floatArray[n2][1].floatValue()))) continue;
                nArray[n] = 1;
            }
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        return n2;
    }

    public static HashMap<String, String> readFasta(String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = new File(string);
        if (file.exists()) {
            String string2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            bufferedReader = string.toLowerCase().endsWith(".gz") || string.toLowerCase().endsWith(".gzip") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (string3.startsWith(">")) {
                    if (string2 != null) {
                        hashMap.put(string2, stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                    }
                    string2 = string3.substring(1);
                } else {
                    stringBuilder.append(string3);
                }
                string3 = bufferedReader.readLine();
            }
            if (string2 != null && !hashMap.containsKey(string2)) {
                hashMap.put(string2, stringBuilder.toString());
            }
            bufferedReader.close();
        }
        return hashMap;
    }

    public static TreeMap<String, Double> readScores(String string) throws Exception {
        TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
        File file = new File(string);
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            bufferedReader = string.toLowerCase().endsWith(".gz") || string.toLowerCase().endsWith(".gzip") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = string2.split("\t");
                try {
                    double d = Double.parseDouble(stringArray[1]);
                    treeMap.put(stringArray[0], d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return treeMap;
    }
}

