% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{generateReportSA}
\alias{generateReportSA}
\title{Method generateReportSA}
\usage{
generateReportSA(
  object,
  outputDir = NULL,
  includeSangerContig = TRUE,
  includeSangerRead = TRUE,
  colors = "default",
  ...
)
}
\arguments{
\item{object}{A SangerAlignment S4 instance.}

\item{outputDir}{The output directory of the generated HTML report.}

\item{includeSangerContig}{The parameter that decides whether to include SangerContig level report. The value is \code{TRUE} or \code{FALSE} and the default is \code{TRUE}.}

\item{includeSangerRead}{The parameter that decides whether to include SangerRead level report. The value is \code{TRUE} or \code{FALSE} and the default is \code{TRUE}.}

\item{colors}{A vector for users to set the colors of (A, T, C, G, else). 
There are three options for users to choose from. 
  1. "default":  (green, blue, black, red, purple). 
  2. "cb_friendly":  ((0, 0, 0), (199, 199, 199), (0, 114, 178), (213, 94, 0), (204, 121, 167)). 
  3. Users can set their own colors with a vector with five elements.}

\item{...}{Further generateReportSA-related parameters.}
}
\value{
The output absolute path to the SangerAlignment's HTML file.
}
\description{
Method generateReportSA
}
\examples{
data(sangerAlignmentData)
\dontrun{
generateReportSA(sangerAlignmentData)}
}
