% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayTopology.R
\name{retrieve_topology}
\alias{retrieve_topology}
\title{Retrieve pathway topology as weighted adjacency matrices}
\usage{
retrieve_topology(
  database = c("kegg", "wikipathways", "reactome"),
  species = c("hsapiens", "athaliana", "btaurus", "celegans", "cfamiliaris",
    "dmelanogaster", "drerio", "ecoli", "ggallus", "mmusculus", "rnorvegicus",
    "scerevisiae", "sscrofa", "xlaevis"),
  keyword = NULL,
  beta = NULL
)
}
\arguments{
\item{database}{A character vector of supported databases.}

\item{species}{One of the supported species. Currently support \code{c("hsapiens", "athaliana", "btaurus", "celegans", "cfamiliaris", "dmelanogaster", "drerio", "ecoli", "ggallus", "mmusculus","rnorvegicus", "scerevisiae", "sscrofa", "xlaevis")}}

\item{keyword}{Optional. Areas of interests as a character vector.}

\item{beta}{Optional. A named numeric vector of weights to be assigned to
each type of gene/protein relation type.See details for more information.}
}
\value{
A list where each element is a weighted directed adjacency
matrix corresponding to a pathway
}
\description{
Retrieve pathway topology matrices and convert them to normalized
weighted directed adjacency matrices describing gene signaling networks.
}
\details{
This function takes pathway topology information retrieved using \code{graphite}
and converts these to normalized weighted directed adjacency matrices
describing the gene signaling network, which can be used to compute gene-wise
and pathway-level perturbation score through the scoring algorithm derived
from the \emph{SPIA} algorithm. See cited document for more details.

The \code{database} parameter may specify multiple databases but only one species
can be provided to the \code{species} parameter.

Users can provide areas of interests as keywords, which will be matched to
pathway names from chosen databases to subset pathways. Cases will be
ignored in string matching.

The beta parameter specifies weights to be assigned to each type of gene-gene
interaction. It should be a named numeric vector of length 25,
whose names must be: \code{c("activation","compound","binding/association", "expression","inhibition","activation_phosphorylation","phosphorylation", "indirect","inhibition_phosphorylation","dephosphorylation_inhibition", "dissociation","dephosphorylation","activation_dephosphorylation", "state","activation_indirect","inhibition_ubiquination","ubiquination", "expression_indirect","indirect_inhibition","repression", "binding/association_phosphorylation","dissociation_phosphorylation", "indirect_phosphorylation")}.

If unspecified, beta will be set as an integer vector with: a) values of 1
for interactions which match 'expression' or 'activation'; b) values of -1
for interactions which match 'repression' or 'inhibition'; and c) 0
elsewhere.

The retrieved topology matrices will be processed as decribed by \emph{SPIA} to: 1)
scale gene-gene interactions by the number of downstream genes and 2) subtract
an identity matrix of the same size from the topology matrix.

The converted weighted adjacent matrices will be stored in a list. We
recommend users to store the returned list as a file so this step only
needs to be performed once for each database.
}
\examples{
\donttest{
# retrieve pathway topology matrices of all KEGG pathway
gsTopology <- retrieve_topology(database = "kegg", species = "hsapiens")

# If only interested in selected pathways, specify the areas of interest as
# keywords
gsTopology <- retrieve_topology(database = "kegg",
keyword = c("metabolism", "signaling"), species = "hsapiens")
}
}
\references{
Tarca AL, Draghici S, Khatri P, Hassan SS, Mittal P, Kim JS,
Kim CJ, Kusanovic JP, Romero R. A novel signaling pathway impact analysis.
Bioinformatics. 2009 Jan 1;25(1):75-82.
Sales, G., Calura, E., Cavalieri, D. et al. graphite - a Bioconductor package
to convert pathway topology to gene network. BMC Bioinformatics 13, 20 (2012).
}
