% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normaliseByPermutation.R
\name{generate_permuted_scores}
\alias{generate_permuted_scores}
\alias{generate_permuted_scores,matrix-method}
\alias{generate_permuted_scores,data.frame-method}
\alias{generate_permuted_scores,DGEList-method}
\alias{generate_permuted_scores,SummarizedExperiment-method}
\title{Permute sample labels to simulate null distribution of perturbation scores}
\usage{
generate_permuted_scores(
  expreMatrix,
  NB = NULL,
  testScore = NULL,
  gsTopology,
  weight,
  drop = TRUE
)

\S4method{generate_permuted_scores}{matrix}(
  expreMatrix,
  NB = NULL,
  testScore = NULL,
  gsTopology,
  weight,
  drop = TRUE
)

\S4method{generate_permuted_scores}{data.frame}(
  expreMatrix,
  NB = NULL,
  testScore = NULL,
  gsTopology,
  weight,
  drop = TRUE
)

\S4method{generate_permuted_scores}{DGEList}(
  expreMatrix,
  NB = NULL,
  testScore = NULL,
  gsTopology,
  weight,
  drop = TRUE
)

\S4method{generate_permuted_scores}{SummarizedExperiment}(
  expreMatrix,
  NB = NULL,
  testScore = NULL,
  gsTopology,
  weight,
  drop = TRUE
)
}
\arguments{
\item{expreMatrix}{\code{matrix} and \code{data.frame} of logCPM, or \code{DGEList}/\code{SummarizedExperiment}
storing gene expression counts. Feature names need to be in entrez IDs}

\item{NB}{Number of permuted sample pairs to compute permuted logFCs for.
Default to be the maximum number of possibilities (See details).}

\item{testScore}{Optional. Output of \code{pathway_pert()} for restricting the
permutation only to pathways with non-zero test scores in at least one sample.}

\item{gsTopology}{List of pathway topology matrices generated using function \code{retrieve_topology}}

\item{weight}{A vector of gene-wise weights derived from function \code{weight_ss_fc}}

\item{drop}{logic(1). Whether to drop pathways with all zero scores}
}
\value{
A list where each element is a vector of perturbation scores for a pathway.
}
\description{
Simulate null distributions of perturbation scores for each
pathway through sample permutation.
}
\details{
This \code{generate_permuted_scores} function firstly randomly permute sample labels
to form permuted pairs and generate permuted logFCs, which are then used to
compute permuted perturbation scores for each pathway.

The function outputs a list that is of the same length as the list storing
pathway topology matrices (i.e. \code{gsTopology}). Each element of the output list
corresponds to one pathway and contains a vector of permuted perturbation scores.
The permuted perturbation scores will be used to approximate the null distributions
of perturbation scores and compute permuted p-values.

If the input is S4 object of \code{DGEList or SummarizedExperiment}, gene expression
matrix will be extracted and converted to a logCPM matrix.

The sample permutation is operated by randomly choosing combination of 2 samples
from the column names of the \code{expreMatrix}. Hence, sample metadata is not a
required input. The number of maximum unique permutations in a dataset with N
samples is N x (N-1). By default, permuted logFCs will be computed for all N x (N-1)
permuted pairs. However, this can be overwritten by the \code{NB} parameter.
If the \code{NB} specified is smaller than N x (N-1), \code{NB} possibilities will be randomly
sampled from all the possible permutation. If the \code{NB} specified is larger than
the maximum number of permutation possible, the parameter will be ignored.
Since the smallest achievable permutation p-value is 1/\code{NB}, accurate estimation
of small p-value requires a large number of permutations that is only feasible
in data with a large sample size.
}
\examples{
#compute weighted single sample logFCs
data(metadata_example)
data(logCPM_example)
metadata_example <- dplyr::mutate(metadata_example, treatment = factor(
   treatment, levels = c("Vehicle", "E2+R5020", "R5020")))
ls <- weight_ss_fc(logCPM_example, metadata = metadata_example,
 groupBy = "patient", treatColumn = "treatment", sampleColumn = "sample")
\dontrun{
load(system.file("extdata", "gsTopology.rda", package = "sSNAPPY"))

# simulate the null distribution of scores through sample permutation
permutedScore <- generate_permuted_scores(logCPM_example,
gsTopology = gsTopology, weight = ls$weight)

 }
}
