% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeCircuit<-}
\alias{sracipeCircuit<-}
\alias{sracipeCircuit<-,RacipeSE-method}
\alias{sracipeCircuit-set}
\title{Initialize the circuit}
\usage{
sracipeCircuit(.object) <- value

\S4method{sracipeCircuit}{RacipeSE}(.object) <- value
}
\arguments{
\item{.object}{RacipeSE object}

\item{value}{data.frame containing the circuit information}
}
\value{
data.frame
}
\description{
Initialize the circuit from a topology file
or a \code{data.frame}
A typical topology file looks like
\tabular{lcr}{
  Source \tab Target \tab Type \cr
  geneA \tab geneB \tab 2 \cr
  geneB \tab geneC \tab 1 \cr
  geneB \tab geneA \tab 2
}
Here the regulation type is specified by number - TF activation: \code{1},
 TF inhibition: \code{2}
 degradation inhibition: \code{3}
 degradation activation: \code{4}
 signaling activation: \code{5}
 signaling inhibition: \code{6}
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}}
}

\examples{
RacipeSet <- RacipeSE()
data("demoCircuit")
sracipeCircuit(RacipeSet) <- demoCircuit
sracipeCircuit(RacipeSet)
rm(RacipeSet, demoCircuit)
}
