% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pairwiseLCS}
\alias{pairwiseLCS}
\title{Calculate a matrix of Longest Common Subsequence (LCS) 
between a pair of numeric vectors}
\usage{
pairwiseLCS(x, y)
}
\arguments{
\item{x}{an integer vector}

\item{y}{an integer vector}
}
\value{
a matrix computed using dynamic programming
that stores the Longest Common Subsequence (LCS) between two vectors A and B.
}
\description{
This function calculates the matrix with Longest Common Subsequence (LCS)
between two numeric vectors. From given matrix we can locate the size 
of the Longest Common Subsequence in the last column in the last row.
}
\examples{
A <- c(1, 2, 3, 4, 5)
B <- c(1, 2, 4)
pairwiseLCS(A, B)

}
\seealso{
\code{\link{runibic}}  \code{\link{calculateLCS}} \code{\link{backtrackLCS}}
}
