% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_nodes}
\alias{find_nodes}
\title{Search for nodes by name or semantic type}
\usage{
find_nodes(obj, pattern = NULL, names = NULL, semtypes = NULL, match = TRUE)
}
\arguments{
\item{obj}{Either the SemMed graph or a node set (\code{igraph.vs})}

\item{pattern}{Regular expression used to find matches in node names}

\item{names}{Character vector of exact node names}

\item{semtypes}{Character vector of semantic types}

\item{match}{If \code{TRUE}, return nodes that DO match \code{pattern}
(default). If \code{FALSE}, return nodes that DO NOT match.}
}
\value{
A vertex sequence of matching nodes
}
\description{
Search for nodes by name (exact match or using regular expressions) 
or which match supplied semantic types. Perform anti-matching by 
setting \code{match = FALSE}. Capitalization is ignored.
}
\examples{
data(g_mini)
find_nodes(g_mini, pattern = "cortisol")
find_nodes(g_mini, pattern = "cortisol$")
find_nodes(g_mini, pattern = "stress")
find_nodes(g_mini, pattern = "stress") \%>\%
    find_nodes(pattern = "disorder", match = FALSE)

find_nodes(g_mini, names = "Serum cortisol")
find_nodes(g_mini, names = "Chronic Stress")

find_nodes(g_mini, semtypes = "dsyn")
find_nodes(g_mini, semtypes = c("dsyn", "fndg"))

## pattern and semtypes are combined via OR:
find_nodes(g_mini, pattern = "cortisol", semtypes = "horm")

## To make an AND query, chain find_nodes sequenctially:
find_nodes(g_mini, pattern = "cortisol") \%>\%
    find_nodes(semtypes = "horm")

}
