% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlib.R
\name{wordcloudPlot}
\alias{wordcloudPlot}
\title{wordlcoudPlot
Plot GO reduced terms as a wordcloud.}
\usage{
wordcloudPlot(reducedTerms, onlyParents = TRUE, ...)
}
\arguments{
\item{reducedTerms}{a data.frame with the reduced terms from reduceSimMatrix().}

\item{onlyParents}{use only parent terms to calculate frequencies.}

\item{...}{other parameters sent to wordcloud::wordcloud()}
}
\value{
Nothing
}
\description{
wordlcoudPlot
Plot GO reduced terms as a wordcloud.
}
\examples{
go_analysis <- read.delim(system.file("extdata/example.txt", package="rrvgo"))
simMatrix <- calculateSimMatrix(go_analysis$ID, orgdb="org.Hs.eg.db", ont="BP", method="Rel")
scores <- setNames(-log10(go_analysis$qvalue), go_analysis$ID)
reducedTerms <- reduceSimMatrix(simMatrix, scores, threshold=0.7, orgdb="org.Hs.eg.db")
wordcloudPlot(reducedTerms, min.freq=1, colors="black")
}
