% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_fragmentation.r
\name{rifi_fragmentation}
\alias{rifi_fragmentation}
\title{\subsection{=========================================================================
rifi_fragmentation}{

rifi_fragmentation wraps conveniently all fragmentation steps
}}
\usage{
rifi_fragmentation(
  inp,
  cores = 1,
  pen_delay = NULL,
  pen_out_delay = NULL,
  pen_HL = NULL,
  pen_out_HL = NULL,
  pen_inty = NULL,
  pen_out_inty = NULL,
  pen_TU = NULL,
  pen_TI = NULL,
  pen_out_TI = NULL
)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{cores}{integer: the number of assigned cores for the task.}

\item{pen_delay}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default is the auto generated value.}

\item{pen_out_delay}{numeric: an internal parameter for the dynamic
programming. Higher values result in fewer allowed outliers. Default is the
auto generated value.}

\item{pen_HL}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default is the auto generated value.}

\item{pen_out_HL}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer allowed outliers. Default is the auto generated
value.}

\item{pen_inty}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default is the auto generated value.}

\item{pen_out_inty}{numeric: an internal parameter for the dynamic
programming. Higher values result in fewer allowed outliers. Default is
the auto generated value.}

\item{pen_TU}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default -0.75.}

\item{pen_TI}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default is the auto generated value.}

\item{pen_out_TI}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer allowed outliers. Default is the auto generated
value.}
}
\value{
the SummarizedExperiment object: with delay_fragment, HL_fragment,
intensity_fragment, TI_termination_fragment and TU, and the respective values
added to the rowRanges.
}
\description{
rifi_fragmentation is wrapper of the following functions:
\enumerate{
\item fragment_delay
\item fragment_HL
\item fragment_inty
\item TUgether
\item fragment_TI
}
}
\examples{
data(penalties_minimal)
rifi_fragmentation(inp = penalties_minimal, cores = 2)

}
\seealso{
\code{fragment_delay}

\code{fragment_HL}

\code{fragment_inty}

\code{TUgether}

\code{fragment_TI}
}
