% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_visualization_comparison.r
\name{rifi_visualization_comparison}
\alias{rifi_visualization_comparison}
\title{rifi_visualization_comparison plots the segments and genome annotation}
\usage{
rifi_visualization_comparison(
  data,
  data_c,
  genomeLength = annot_g[[2]],
  annot = annot_g[[1]],
  condition = c("cdt1", "cdt2"),
  Strand = c("+", "-"),
  region = c("CDS", "asRNA", "5'UTR", "ncRNA", "3'UTR", "tRNA"),
  color_region = c("grey0", "red", "blue", "orange", "yellow", "green", "white",
    "darkseagreen1", "grey50", "black"),
  color_TU = c("cyan", "yellow", "orange"),
  scaling_TU = c(0, 3.4, 6.6),
  color_text.1 = "grey0",
  color_text.2 = "black",
  Alpha = 0.5,
  size_tu = 1.6,
  size_locusTag = 1.6,
  size_gene = 1.6,
  Limit = 10,
  shape = 22,
  face = "bold",
  tick_length = 0.3,
  arrow.color = "darkseagreen1",
  col_above20 = "#00FFFF",
  fontface = "plain",
  shape_above20 = 14,
  axis_text_y_size = 3,
  axis_title_y_size = 6,
  iTSS_threshold = 1.2,
  p_value_manova = 0.05,
  termination_threshold = 0.8
)
}
\arguments{
\item{data}{dataframe: the probe based dataframe with joined columns.}

\item{data_c}{dataframe: the probe based dataframe with joined rows.}

\item{genomeLength}{integer: genome length output of gff3_preprocess
function.}

\item{annot}{dataframe: the annotation file.}

\item{condition}{string: assigned as cdt1 (condition 1) and cdt2
(condition2), it could be adapted to any name.}

\item{Strand}{string: either ("+" or "-").}

\item{region}{dataframe: gff3 features of the genome.}

\item{color_region}{string vector: vector of colors.}

\item{color_TU}{string. TU color}

\item{scaling_TU}{vector: values to adjusted termination and iTSSs to TUs.}

\item{color_text.1}{string: TU color text}

\item{color_text.2}{string: genes color text}

\item{Alpha}{integer: color transparency degree.}

\item{size_tu}{integer: TU size}

\item{size_locusTag}{integer: locus_tag size}

\item{size_gene}{integer: font size for gene annotation.}

\item{Limit}{integer: value for y-axis limit.}

\item{shape}{integer: value for shape.}

\item{face}{string: label font.}

\item{tick_length}{integer: value for ticks.}

\item{arrow.color}{string: arrows color.}

\item{col_above20}{string: color for probes/bin above value 20.}

\item{fontface}{integer: font type}

\item{shape_above20}{integer: shape for probes/bins above value 20.}

\item{axis_text_y_size}{integer: text size for y-axis.}

\item{axis_title_y_size}{integer: title size for y-axis.}

\item{iTSS_threshold}{integer: threshold for iTSS_II selected to plot,
default 1.2.}

\item{p_value_manova}{integer: p_value of manova test fragments to plot,
default 0.05.}

\item{termination_threshold}{integer: threshold for termination to plot,
default .8.}
}
\value{
The plot.
}
\description{
rifi_visualization_comparison plots the genome annotation, half-life
difference (HL), log2FC(intensity) fragments. It uses several functions to
plot TUs and genes including small-RNAs. Additionally it plots the
statistical t-test between the neighboring fragment, significant p-values
from t-test are assigned with '*'.
}
\details{
The functions used are:

strand_selection: plots HL, intensity fragments from both strands.

splitGenome_function: splits the genome into fragments.

annotation_plot_comp: plots the corresponding annotation.

indice_function: assign a new column to the data to distinguish between
fragments, outliers from delay or HL or intensity.

empty_data_positive: plots empty boxes in case no data is available for
positive strand

empty_data_negative: plots empty boxes in case no data is available for
negative strand

TU_annotation: designs the segments border for the genes and TUs annotation.

gene_annot_function: it requires gff3 file, returns a dataframe adjusting
each fragment according to its annotation. It allows as well the plot of
genes and TUs shared into two pages.

secondaryAxis: adjusts the half-life or delay to 20 in case of the dataframe
row numbers is equal to 1 and the half-life or delay exceed the limit,
they are plotted with different shape and color.

my_arrow: creates an arrow for the annotation.

arrange_byGroup: selects the last row for each segment and add 40 nucleotides
in case of negative strand for a nice plot.

my_segment_T: plots terminals and pausing sites labels.
}
\examples{
data(data_combined_minimal)
data(stats_df_comb_minimal)
data(annot_g)
rifi_visualization_comparison(
    data = data_combined_minimal,
    data_c = stats_df_comb_minimal,
    genomeLength = annot_g[[2]],
    annot = annot_g[[1]]
    ) 
    
}
