% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaPlot.R
\name{metaPlot}
\alias{metaPlot}
\title{Metagene analysis plot}
\usage{
metaPlot(
  UTR5coverage,
  CDScoverage,
  UTR3coverage,
  sample,
  xaxis = c("RPFs", "mRNA"),
  bins = c(UTR5 = 100, CDS = 500, UTR3 = 100),
  ...
)
}
\arguments{
\item{UTR5coverage, CDScoverage, UTR3coverage}{Coverages of UTR5, CDS, and
UTR3 region.
Output of \link{coverageDepth}}

\item{sample}{character(1). Sample name to plot.}

\item{xaxis}{What to plot for x-axis.}

\item{bins}{Bins for UTR5, CDS and UTR3.}

\item{...}{Parameter pass to plot.}
}
\value{
A list contain the data for plot.
}
\description{
Plot the average coverage of UTR5, CDS and UTR3.
}
\examples{

\dontrun{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
RNAs <- dir(path, "mRNA.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
cvgs <- coverageDepth(RPFs[1], RNAs[1], gtf)
cvgs.utr3 <- coverageDepth(RPFs[1], RNAs[1], gtf, region="utr3")
cvgs.utr5 <- coverageDepth(RPFs[1], RNAs[1], gtf, region="utr5")
metaPlot(cvgs.utr5, cvgs, cvgs.utr3, sample=1)
}
}
