% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPsiteCoordinates.R
\name{getPsiteCoordinates}
\alias{getPsiteCoordinates}
\title{Get P site coordinates}
\usage{
getPsiteCoordinates(
  bamfile,
  bestpsite,
  anchor = "5end",
  param = ScanBamParam(what = c("qwidth"), tag = character(0), flag =
    scanBamFlag(isSecondaryAlignment = FALSE, isUnmappedQuery = FALSE,
    isNotPassingQualityControls = FALSE, isSupplementaryAlignment = FALSE))
)
}
\arguments{
\item{bamfile}{A BamFile object.}

\item{bestpsite}{P site postion. See \link{estimatePsite}}

\item{anchor}{5end or 3end. Default is 5end.}

\item{param}{A ScanBamParam object. Please note the 'qwidth' is required.}
}
\value{
A GRanges object with qwidth metadata which indicates the width
of reads.
}
\description{
Extract P site coordinates from a bam file to a GRanges object.
}
\examples{
library(Rsamtools)
bamfilename <- system.file("extdata", "RPF.WT.1.bam",
                           package="ribosomeProfilingQC")
yieldSize <- 10000000
bamfile <- BamFile(bamfilename, yieldSize = yieldSize)
pc <- getPsiteCoordinates(bamfile, bestpsite=13)
}
